/* act_parser.c
 *     $B4X?t(B main() $B$,8F$S=P$9%H%C%W%l%Y%k$N(B parser
 *
 */

#include <stdio.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <parsers.h>
#include <tokens.h>
#include <lex.h>

char clcword[BUFSIZE];
extern int method_lex(void);

int act_parser()
{
  int token;
  int result;

  rewind(cpl_fp); /* $B%U%!%$%k%]%$%s%?$r@hF,$K;}$C$F$$$/(B */
  result = TRUE;
  while((token = method_lex()) != EOF){
    switch(token){
    case PARA_DEF:
      fprintf(stderr, "enter a parser for parameter.\n");
      if((num_of_para = para_parser(para_list)) > 0) result = TRUE;
      else result = FAIL;
      break;
    case CONV_DEF:
      fprintf(stderr, "enter a parser for convert.\n");
      result = conv_parser();
      break;
    case IMPORT_METHOD:
      fprintf(stderr, "enter a parser for import method.\n");
       result = import_parser();
      break;
    case EXPORT_METHOD:
      fprintf(stderr, "enter a parser for export method.\n");
       result = export_parser();
      break;
    case SUBSTANCE_QUERY:
      fprintf(stderr, "enter a parser for substance query.\n");
      result = query_parser();
      break;
    case SUBSTANCE_CALL:
      fprintf(stderr, "enter a parser for substance call.\n");
      result = call_parser();
      break;
    case NEGOTIATION_STRATEGY:
      fprintf(stderr, "enter a parser for negotiation strategy.\n");
      result = nego_parser();
      break;
    case CAPSULE_PROCEDURE:
      fprintf(stderr, "enter a parser for capsule procedure.\n");
      result = proc_parser();
      break;
    }
  }
  return result;
}

/* end of top_a parser.c */
