
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <SMessage.h>
#include <SICStus_sub_cap.h>
#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <make_message.h>
#include <method_proc.h>
#include <info_table.h>
#include <CQueue.h>
#include <CRecord.h>
typedef struct{
  CDATA others;
  char list_others[BUFSIZE];
  CDATA top;
  char *str_top;
  CDATA next;
  char *str_next;
  CDATA from;
  char *str_from;
  CDATA date;
  char tuple_date[BUFSIZE];
} _meeting_scheduleParM;
typedef _meeting_scheduleParM *meeting_schedulePar;
typedef struct{
  CDATA date;
  char tuple_date[BUFSIZE];
} _collect_membersParM;
typedef _collect_membersParM *collect_membersPar;
typedef enum {
  NO_STATE = -1,
  QUERY_WAIT,
  REPLY_WAIT,
  RUNNING,
  RUNNING2,
  N_RUNNING,
  P_RUNNING,
  PROC_meeting_schedule_init,
  PROC_meeting_schedule_finish,
  PROC_meeting_schedule_init2,
  PROC_meeting_schedule_init3,
  PROC_meeting_schedule_start_exchange,
  PROC_meeting_schedule_wait,
  PROC_meeting_schedule_result,
  PROC_collect_members_init,
  PROC_collect_members_finish,
  PROC_collect_members_get_answer1,
  PROC_collect_members_get_answer2,
} State;

typedef enum {
  NO_WORLD = -1,
  NORMAL,
  meeting_schedule,
  collect_members,
} World;

struct {
  char *world_name; World world; State init;
} world_list[] = {
  {"meeting_schedule", meeting_schedule, PROC_meeting_schedule_init },
  {"collect_members", collect_members, PROC_collect_members_init },
  { "NORMAL", NORMAL, NO_STATE },
  { NULL, NO_WORLD, NO_STATE }
};
typedef union {
  meeting_schedulePar meeting_schedule;
  collect_membersPar collect_members;
} LocalParM;
typedef LocalParM *LocalPar;
typedef struct {
  int  wtype;  /* NORMAL/0, PROC/1, NEGO/2 */
  World world;
  World preWorld;
  int stateID;
  State state[STACK_SIZE];
  char tid[BUFSIZE];
  LocalPar lPar;
  SMessage start_smg;
} WorldInfoM;
typedef WorldInfoM *WorldInfo;

#define WI         (worldInfo[worldID])
#define WIstate    (worldInfo[worldID]->state[worldInfo[worldID]->stateID])
#define WIstateID  (worldInfo[worldID]->stateID)
#define WItid      (worldInfo[worldID]->tid)
#define WIworld    (worldInfo[worldID]->world)
#define WIpreWorld (worldInfo[worldID]->preWorld)
#define WIlPar     (worldInfo[worldID]->lPar)

int       worldID = -1;
WorldInfo worldInfo[WORLD_SIZE];

typedef struct {
  CDATA MyName;
  char *str_MyName;
  CDATA date;
  char tuple_date[BUFSIZE];
  CDATA others;
  char list_others[BUFSIZE];
} CommonParM;
typedef CommonParM *CommonPar;
typedef struct {
  int  subFd;
  int  activity;
  char agentName[BUFSIZE];
  char agentID[BUFSIZE];
  CommonPar cPar;
} AgentInfo;
AgentInfo agentInfo;
MethodData MethodList[]={
  { IMPORT, -1, "begin_transaction", NULL, NORMAL, "NORMAL", ASKBeginTransaction, NULL },
  { IMPORT, -1, "commit",            NULL, NORMAL, "NORMAL", ASKCommit,           NULL },
  { IMPORT, -1, "begin_negotiation", NULL, NORMAL, "NORMAL", ASKBeginNegotiation, NULL },
  { IMPORT, SUB_CALL, "want_member", "calc_utility",
    NORMAL, "NORMAL", ASKtoCALL, NULL },
  { IMPORT, SUB_CALL, "exchange_member", "put_member",
    NORMAL, "NORMAL", ASKtoCALL, NULL },
  { IMPORT, PROC, "scheuduling", "scheuduling",
    meeting_schedule, "meeting_schedule", ASKtoPROC, NULL },
  { SUB_CALL, REPLY, "utility", "calc_utility",
    NORMAL, "NORMAL", RESULTtoREPLY, NULL },
  { SUB_CALL, REPLY, "delete_member", "put_member",
    NORMAL, "NORMAL", RESULTtoREPLY, NULL },
  { SUB_CALL, REPLY, "scheduling", "make_a_schedule",
    NORMAL, "NORMAL", RESULTtoREPLY, NULL },
  { SUB_CALL, REPLY, "absentees", "get_absentees",
    NORMAL, "NORMAL", RESULTtoREPLY, NULL },
  { SUB_QUERY, PROC, "collect_members", "collect_members",
    collect_members, "collect_members", QUERYtoPROC, NULL },
  { -1, -1, NULL, NULL, -1, NULL, NULL, NULL },
};
nego_proc_data nego_proc_list[]={
  { PROC, meeting_schedule,
    PROC_ParaInit_meeting_schedule, PROC_ParaFree_meeting_schedule },
  { PROC, collect_members,
    PROC_ParaInit_collect_members, PROC_ParaFree_collect_members },
  { -1, -1, -1, -1, -1, NULL, NULL },
};

nego_proc_proc_data nego_proc_proc_list[]={
  { PROC, meeting_schedule, PROC_meeting_schedule_start_exchange, 1, -1,
    "make_a_schedule", PROC_meeting_schedule_start_exchange_SubInfo_make_a_schedule },
  { PROC, collect_members, PROC_collect_members_get_answer2, 0, 1,
    "not_meeting", PROC_collect_members_get_answer2_ExteranlReply_not_meeting },
  { -1, -1, -1, -1, -1, NULL, NULL },
};

