/* worldInfo.h
 *    header file for definition of a world infomation.
 */
#include "CaplDef.h"
#include "CData.h"

#ifndef __worldInfo__
#define __worldInfo__

#define WI         (worldInfo[worldID])
#define WIstate    (worldInfo[worldID]->state[worldInfo[worldID]->stateID])
#define WIstateID  (worldInfo[worldID]->stateID)
#define WItid      (worldInfo[worldID]->tid)
#define WIworld    (worldInfo[worldID]->world)
#define WIpreWorld (worldInfo[worldID]->preWorld)
#define WIlPar     (worldInfo[worldID]->lPar)

struct _NegoContractNetParM { /* CAPL$B$N5-=R$K$h$k(B _Nego<$B8r>DL>(B>Par */
  CommonData from;            /* CAPL$B$N5-=R$K$h$k(B */
  CommonData master;          /* CAPL$B$N5-=R$K$h$k(B */
  CommonData contractor;      /* CAPL$B$N5-=R$K$h$k(B */
};        /* CAPL$B$N5-=R$K$h$k(B Nego<$B8r>DL>(B>Par */

typedef struct _NegoContractNetParM  NegoContractNetParM;
typedef NegoContractNetParM *NegoContractNetPar;

union _LocalParM {
  NegoContractNetPar negoContractNet; /* CAPL$B$N5-=R$K$h$k(B nego<$B8r>DL>(B> */
};
typedef union _LocalParM LocalParM;
typedef LocalParM *LocalPar;

struct _WorldInfoM{
  int  wtype;  /* NORMAL/0, PROC/1, NEGO/2 */
  enum World world;
  enum World preWorld;
  int stateID;
  enum State state[STACK_SIZE];
  char tid[BUFSIZE];
  LocalPar lPar;
  SMessage start_smg;
};
typedef struct _WorldInfoM WorldInfoM;
typedef WorldInfoM *WorldInfo;

extern int       worldID;
extern WorldInfo worldInfo[];

extern int WIPush(enum World world, enum State state, char *tid);
extern int WIPop(void);
extern int WIChangeState(enum State);
extern int WIPushState(enum State);
extern int WIPopState(void);
extern char *GenerateTid(char *tid);
#endif __worldInfo__
/* end of worldInfo.h */
