/* worldInfo.c
 *    module for handling a world infomation.
 *
 */

#include <string.h>
#include <stdlib.h>
#include "worldInfo.h"

int       worldID = -1;
WorldInfo worldInfo[WORLD_SIZE];

int
  WIPush(enum World world, enum State state, char *tid)
{
  WorldInfo worldInfo;
  int preID;

  preID = worldID;
  if(++worldID == WORLD_SIZE){
    fprintf(stderr, "overflow of world stack.\n");
    exit(-1);
  }
  WI = (WorldInfo)malloc(sizeof(WorldInfoM));
  if(worldInfo == NULL){
    fprintf(stderr, "fail of malloc in WINew().\n");
    exit(-1);
  }
  WIworld = world;
  if(preID > -1){
    WIpreWorld = worldInfo[preID]->world;
  }
  else{
    WIpreWorld = NULL_WORLD;
  }
  WIstate = state;
  WIstateID = 0;
  if(tid != (char *)NULL)
    strcpy(WItid, tid);
  else
    WIworldID = (char *)NULL;
  return worldID;
}

int
  WIPop(void)
{
  NP_ParaFree(WIworld)();
  free(worldInfo[worldID]);
  worldInfo[worldID] = (WorldInfo)NULL;
  worldID -= 1;
  return worldID;
}

int
  WIChangeState(enum State)
{
  worldInfo[worldID]->state[StateID] = State;
  return TRUE;
}

int
  WIPushState(enum State)
{
  worldInfo[worldID]->stateID += 1;
  if(worldInfo[world]->stateID < STACK_SIZE){
    worldInfo[worldID]->state[stateID] = State;
  }
  else{
    fprintf(stderr, "overflow of state stack in a world.\n");
    exit(-1);
  }
  return TRUE;
}

int
  WIPopState(void)
{
  worldInfo[worldID]->stateID -= 1;
  if(worldInfo[worldID]->stateID < 0){
    fprintf(stderr, "underflow of stack in a world.\n");
    exit(-1);
  }
  return TRUE;
}

char*
  GenerateTid(char *tid)
{
  static int id = 0;
  sprintf(tid, "%s:%d", agentInfo.agentName, id++);
  return tid;
}

int (*NP_ParaFree(void))(World world)
{
  for(i = 0; nego_proc_proc_list[i].np_type != -1; i++){
    if(world == nego_proc_list[i].world)
      return nego_proc_list[i].proc_free;
  }
  return NULL;
}

int (*NP_ParaInit(void))(World world)
{
  for(i = 0; nego_proc_proc_list[i].np_type != -1; i++){
    if(world == nego_proc_list[i].world)
      return nego_proc_list[i].proc_init;
  }
  return NULL;
}

World SelectCapsuleProcedure(int event_type, char *method, char *world_name)
{
  int i;
  for(i = 0; i < MethodList[i].event_type != -1; i++){
    if(MethodList[i].event_type == event_type &&
       MethodList[i].proc_type == PROC &&
       strcmp(MethodList[i].outer_method, method) == 0){
      strcpy(world_name, MethodList.world_name);
      return MethodList[i].world;
    }
  }
  return NO_WORLD;
}

World SelectNegotiationStrategy(int event_type, char *method, char *world_name)
{
  int i;
  for(i = 0; i < MethodList[i].event_type != -1; i++){
    if(MethodList[i].event_type == event_type &&
       MethodList[i].proc_type == NEGO &&
       strcmp(MethodList[i].outer_method, method) == 0){
      strcpy(world_name, MethodList[i].world_name);
      return MethodList[i].world;
    }
  }
  return NO_WORLD;
}

World SelectNP_id(char *name)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(stcmp(name, world_list[i].world_name) == 0)
      return world_list[i].world_id;
  }
  return NO_WORLD;
}

/* end of worldInfo.c */
