#include <stdio.h>
#include <string.h>
#include "capldata.h"
#include "warn.h"
#include "tokens.h"
#include "parser.h"
#include "info_table.h"
int
  SelectMessage(enum QueueType *qType, SMessage *smg)
{
  char *ids[TABLE_MAX];
  int i;

  for(i = 0; i < TABLE_MAX; i++) ids[i] = NULL;
  SMessage tmp;
  if(WIwtype == NORMAL){
    if(WIstate == QUERY_WAIT){
      select_normal_method(IMPORT, ids);
      *smg = CQDequeue(queue[MsgQ], ASK, NULL, WItid, ids);
    }
    else if(WIstate == REPLY_WAIT){
      CRMultiSelect(SUBSTANCE, EXTERNAL, WItid, ids);
      *smg = CQDequeue(queue[MsQ], REPLY, ids, WItid, NULL);
      if(*smg == NULL && lock_swt == OFF){
	for(i = 0; i < TABLE_MAX; i++){
	  if(ids[i] != NULL) free(ids[i]);
	}
	*smg = CQDequeue(queue[MsgQ], ASK, NULL, WItid, ids);
      }
    }
    else if(WIstate == RUNNING){
      select_normal_method(QUERY, ids);
      *smg = CQDequeue(queue[SIQ], ASK, NULL, WItid, ids);
    }
    else if(WIstate == N_RUNNING){
      CRMultiSelect(-1, NEGOTIATION, WItid, ids);
      *smg = CQDequeue(queue[NPQ], REPLY, ids, WItid, NULL);
    }
    if(WIstate == P_RUNNING){
      CRMultiSelect(-1, PROCEDURE, WItid, ids);
      *smg = CQDequeue(queue[NPQ], REPLY, ids, WItid, NULL);
    }
  }
  else {
    if(WIwtype == NEGO){
      while(1){
	tmp = CQDequeue(queu[MsgQ], REPLY, NULL, WItid, NULL);
	if(tmp != NULL) CSMDelete(smg);
	else break;
      }
    }
    *smg = NULL;
    for(i = 0; nego_proc_proc_list[i].np_type != -1; i++){
      if(nego_proc_proc_list[i].np_type == WIwtype &&
	 nego_proc_proc_list[i].world == WIworld &&
	 nego_proc_proc_list[i].state == WIstate){
	*smg = CDenqueue(queue[nego_proc_proc_list[i].qtype],
			 nego_proc_proc_list[i].mtype,
			 NULL,
			 WItid,
			 nego_proc_proc_list[i].method);
      }
    }
    if(*smg == NULL){
    }      
  }
  for(i = 0; i < TABLE_MAX; i++){
    if(ids[i] != NULL) free(ids[i]);
  }
  return TRUE;
}

int MethodProcedure(int i, SMessage smg)
{
  if(WIwtype == NORMAL){
    return MethodList[i].method_proc(smg);
  }
  else{
    return np_proc_proc_list[i].method_proc(smg);
  }
}

select_normal_method(int event, char *methods[])
{
  int i;
  int j;
  for(i = 0, j = 0; MethodList[i].event_type == -1; i++){
    if(MethodList[i].event == event){
      methods[j++] = strdup(MethodList[i].outer_method);
    }
  }
  methods[j] = NULL;
  return TRUE;
}
