#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <info_table.h>
#include <make_message.h>
#include <CQueue.h>
#include <CRecord.h>
#include <CaplDef.h>

extern int worldID;
extern char PHYSICAL_AGENT_ID;

static char *new_tid()
{
  char buffer[BUFSIZE];
  static int no = -1;

  no = (no+1)%1000;
  sprintf(buffer, "%s_%d", PHYSICAL_AGENT_ID, no);
  return strdup(buffer);
}

/* QUERYtoASK(SMessaeg smg) */
int QUERYtoASK(SMessage smg)
{
  CDATA tmps;
  char *data;
  char *inner_method;
  int i;
  int (*func)(char*, SMessage);

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPSubstanceConvLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPMethodConvCommonEnv(inner_method, tmps);
    CDelete(tmps);
    func = SelectAskProc(inner_method);
    if(func != NULL) func(data, smg);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from substance to common \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agentInfo.activity == EXIT;
  }
  return TRUE;
}

/* ASKtoQUERY */
int ASKtoCALL(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  char call_id[BUFSIZE];
  char errorSmg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    call_id = CallSubstanceProcedure(data, call_id);
    CREnqueue(smg, EXTERNAL, SUBSTANCE, call_id, worldID, OFF);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from common to substance \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
    errorSmg = MakeErrorMessage(smg);
    send_message(errorSmg);
  }
  return TRUE;
}

/* ReplyToResult */
int REPLYtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(NULL, NULL, SUBSTANCE, EXTERNAL,
		    CSMGetMisStr(smg), worldID, ON);
    PutResultToSubstance(data, node->query_id);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from common to substance.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ResultToReply */
int RESULTtoREPLY(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;
  SMessage reply_smg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPMethodConvCommonEnv(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(NULL, NULL, EXTERNAL, SUBSTANCE,
		    CSMGetMisStr(smg), worldID, ON);
    reply_smg = MakeReplyMessage(node->smg, data);
    send_message(reply_smg);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from substance to common.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agentInfo.activity == EXIT;
    reply_smg = MakeErrorMessage(node->smg);
    send_message(reply_smg);
  }
  return TRUE;
}

/* NEGO_PROC_RESULTtoREPLY */
int NPtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *data;
  CRNode node;

  tmps = CCommonToStruct(CSMGetDataStr(smg));
  data = CAPSubstanceConvCommonLocal(CSMGetMethodStr(smg), tmps);
  CDelete(tmps);
  node = CRSelect(SUBSTANCE, NEGO_PROC,
		  CSMGetMidStr(smg), worldID, ON);
  PutResultToSubstance(data, node->query_id);
  CRNDelete(node);
  free(data);
  return TRUE;
}

char *SelectInnerMethod(int mtype, char *method, char *inner_method)
{
  int i;

  for(i = 0; MethodDataList[i].mtype != -1; i++){
    if(mtype == MethodDataList[i].mtype &&
       strcmp(method, MethodDataList[i].proc) == 0) break;
  }
  if(MethodDataList[i].mtype != -1){
    strcpy(inner_method, MethodDataList[i].inner_method);
    return inner_method;
  }
  else{
    return NULL;
  }
}

int ASKBeginTransaction(SMessage smg)
{
  char *tid;
  SMessage replySmg;

  tid = new_tid;
  WItid = tid;
  replySmg = MakeReplyMessage("true", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKCommit(SMessage smg)
{
  if(WItid != NULL){
    free(WItid);
    WItid = NULL;
  }
  replySmg = MakeReplyMessage("true", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKBeginNegotiation(SMessage smg)
{
  char *tid;
  int world;

  world = SelectNP_id(CSMGetDataStr(smg));
  if(world != NO_WORLD){
    tid = strdup(CSMGetTidStr(smg));
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  return TRUE;
}

int (*SelectAskProc(int mtype, char *inner_method))(char*, SMessage)
{
  int i;

  for(i = 0; MethodDataList[i].event_type != -1; i++){
    if(MethodDataList[i].event_type == mtype &&
       strcmp(inner_method, MethodDataList[i].inner_method) == 0)
      return MethodDatalist[i].send_proc;
  }
  return NULL;
}

int SelectWorldInit(int world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}

char *CCommonToTOstring(char *org, char *to)
{
  int i;

  for(i = 0; org[i] != NULL; i++){
    if(org == '[' || org == ']' || org == '<' || org == '<' ||
       org == '(' || org == ')' || org == '=' || org == ','){
      to[i] = ' ';
    }
    else{
      to[i] = org[i];
    }
  }
  return to;
}

/* begin_transactin */
