#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <comm.h>
#include <Henv.h>
#include <event.h>
#include <AgentFlags.h>
#include <SMessage.h>
#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <make_message.h>
#include <SICStus_PIPE.h>
#include <CQueue.h>
#include <CRecord.h>
#include <CaplDef.h>

#define WI          (worldInfo[worldID])
#define WIstate     (worldInfo[worldID].state[worldInfo[worldID].sid])
#define WIsid       (worldInfo[worldID].sid)
#define WItid       (worldInfo[worldID].tid)
#define WIworld     (worldInfo[worldID].world)
#define WIpreWorld  (worldInfo[worldID].preWorld)
#define WIlPar      (worldInfo[worldID].LPAR)
#define WIstart_msg (worldInfo[worldID].start_msg)

#define AIsubFD    (agentInfo.subFD)
#define AIname     (agentInfo.agent_name)
#define AIid       (agentInfo.agent_id)
#define AIcPar     (agentInfo.CPAR)
#define AIactvity  (agentInfo.activity)

 #define NO_WORLD -1
#define NORMAL    0
#define meeting_schedule 1
#define exchange_members 2
#define collect_members 3

#define QUERY_WAIT 0
#define REPLY_WAIT 1
#define RUNNING    2
#define RUNNING2   3
#define NP_RUNNING  4
#define meeting_schedule_init 5
#define meeting_schedule_finish 6
#define meeting_schedule_init2 7
#define meeting_schedule_init3 8
#define meeting_schedule_start_exchange 9
#define meeting_schedule_wait 10
#define meeting_schedule_result 11
#define exchange_members_init 12
#define exchange_members_finish 13
#define exchange_members_init2 14
#define collect_members_init 15
#define collect_members_finish 16
#define collect_members_get_answer1 17
#define collect_members_get_answer2 18

typedef struct{
  CDATA others;
  char list_others[BUFSIZE];
  CDATA top;
  char *str_top;
  CDATA next;
  char *str_next;
  CDATA from;
  char *str_from;
  CDATA date;
  char tuple_date[BUFSIZE];
} meeting_schedulePar;
typedef struct{
  CDATA date;
  char tuple_date[BUFSIZE];
} exchange_membersPar;
typedef struct{
  CDATA date;
  char tuple_date[BUFSIZE];
} collect_membersPar;
typedef struct{
  meeting_schedulePar meeting_schedule_par;
  exchange_membersPar exchange_members_par;
  collect_membersPar collect_members_par;
} LocalPar;
typedef struct{
  int wtype;
  int world;
  int sid;  int state[40];
  char *tid;
  LocalPar LPAR;
  SMessage start_msg;
} WorldInfo;

typedef struct {
  int  activity;
  int  subFd;
  char *agent_name;
  char *agent_id;
  struct {
    CDATA MyName;
    char *str_MyName;
    CDATA date;
    char tuple_date[BUFSIZE];
    CDATA others;
    char list_others[BUFSIZE];
  } CPAR;
} AgentInfo;

extern NPMethodData NPMethodList[];
extern AskProc askProc[];
extern NPInitFreeList npInitFreeList[];
extern AgentInfo agentInfo;
extern WorldInfo worldInfo[];
extern int worldID;
extern int ASKtoCALL(SMessage smg);
extern int QUERYtoASK(SMessage smg);
extern int REPLYtoRESULT(SMessage smg);
extern int RESULTtoREPLY(SMessage smg);
extern int ASKto_meeting_schedule(SMessage smg);
extern int meeting_schedule_toREPLY(SMessage smg);

extern int meeting_schedule_start_exchange_SubInfo_make_a_schedule(SMessage smg);
extern int exchange_members_init2_NegoProc_exchange_members(SMessage smg);
extern int collect_members_get_answer2_External_not_meeting(SMessage smg);

extern int ParaInit_meeting_schedule(void);
extern int ParaFree_meeting_schedule(void);
extern int ParaInit_exchange_members(void);
extern int ParaFree_exchange_members(void);
extern int ParaInit_collect_members(void);
extern int ParaFree_collect_members(void);


AgentInfo agentInfo;
WorldInfo worldInfo[STACK_SIZE];
int worldID;

char *LOGICAL_AGENT_NAME = "meeting1";
char *PHYSICAL_AGENT_ID = "(null)";
char *PATH = NULL;
char *SUBSTANCE_NAME = "meeting1.pl";
int lock_swt = 1;
int
  main(int argc, char *argv)
{
  InitializeAgentProcess(argc, argv);
  AgentProcessMainLoop();
  TerminateAgentProcess();
  exit(0);
}

int InitializeAgentProcess(int argc, char *argv[])
{
  int fd;
  char *agent_name;

  if (argc != 2){
    fprintf(stderr, "usage : %s port-number\n", argv[0]);
    exit(1);
  }
    
  agent_name = rindex (argv[0], '/');
  if (agent_name == NULL)  agent_name = argv[0];
  else                     agent_name++;
    
  if (init_comm(atoi(argv[1]), 0) < 0) exit (1);
  init_environment(argc, argv);
  if ((fd = init_SICStus_PIPE_substance(PATH, LOGICAL_AGENT_NAME, SUBSTANCE_NAME)) < 0){
    fprintf(stderr, "cannot connect to substance.\n");
    exit(1);
  }
/*  signal(SIGQUIT, agentCatchupSigQuit);*/
  AIInit(LOGICAL_AGENT_NAME, PHYSICAL_AGENT_ID, fd);

}

int TerminateAgentProcess(void){
  close_environment();
  exit_application();
  close_simple_agent();
}

int AgentProcessMainLoop()
{
  SMessage smg;
  int      event_type;
  int      event_data;

  CQNew(3);

  WIPush(NORMAL, QUERY_WAIT, (char *)NULL);

  while(agentInfo.activity == ON){
    if((smg = CQDequeue(MSGQ, CONTROL, NULL, NULL, NULL)) != NULL) {
      appHandleDebugFlag(smg);
      CSMDelete(smg);
    }
    if(SelectMessageAndProcedure() == FAIL){
      event_type = select_event(&event_data);
      switch(event_type){
      case EVENT_EXIT:
	agentInfo.activity = OFF;
	break;
      case EVENT_MESSAGE_SEND_READY:
	flush_message();
	break;
      case EVENT_MESSAGE_RECEIVE_READY:
	while(receive_message(&smg) == 0)
	  CQEnqueue(MSGQ, smg);
	break;
      case EVENT_IO_READY:
	if (event_data == agentInfo.subFd){
	  while(ReceiveFromSubstance(&smg) == 0)
	    CQEnqueue(SIQ, smg);
	}
	else{
	  fprintf(stderr, "receive data from unkown I/O.\n");
	}
	break;
      }
    }
  }
  return 0;
}
/* end of main.c */
char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_SICStus_PIPE_substance(call);
  sprintf(procID, "%d", callID);
  return procID;
}

int
  AICommonParInit()
{
  char buffer[BUFSIZE];
  agentInfo.CPAR.MyName = CCommonToStruct("\"meeting1\"");
  agentInfo.CPAR.date = NULL;
  agentInfo.CPAR.others = NULL;
  return TRUE;
}

