#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <comm.h>
#include <Henv.h>
#include <event.h>
#include <AgentFlags.h>
#include <SMessage.h>
#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <make_message.h>
#include <SICStus_PIPE.h>
#include <CQueue.h>
#include <CRecord.h>
#include <CaplDef.h>

#define WI          (worldInfo[worldID])
#define WIstate     (worldInfo[worldID].state[worldInfo[worldID].sid])
#define WIsid       (worldInfo[worldID].sid)
#define WItid       (worldInfo[worldID].tid)
#define WIworld     (worldInfo[worldID].world)
#define WIpreWorld  (worldInfo[worldID].preWorld)
#define WIlPar      (worldInfo[worldID].LPAR)
#define WIstart_msg (worldInfo[worldID].start_msg)

#define AIsubFD    (agentInfo.subFD)
#define AIname     (agentInfo.agent_name)
#define AIid       (agentInfo.agent_id)
#define AIcPar     (agentInfo.CPAR)
#define AIactvity  (agentInfo.activity)

 #define NO_WORLD -1
#define NORMAL    0
#define meeting_schedule 1
#define exchange_members 2
#define collect_members 3

#define QUERY_WAIT 0
#define REPLY_WAIT 1
#define RUNNING    2
#define RUNNING2   3
#define NP_RUNNING  4
#define meeting_schedule_init 5
#define meeting_schedule_finish 6
#define meeting_schedule_init2 7
#define meeting_schedule_init3 8
#define meeting_schedule_start_exchange 9
#define meeting_schedule_wait 10
#define meeting_schedule_result 11
#define exchange_members_init 12
#define exchange_members_finish 13
#define exchange_members_init2 14
#define collect_members_init 15
#define collect_members_finish 16
#define collect_members_get_answer1 17
#define collect_members_get_answer2 18

typedef struct{
  CDATA others;
  char list_others[BUFSIZE];
  CDATA top;
  char *str_top;
  CDATA next;
  char *str_next;
  CDATA from;
  char *str_from;
  CDATA date;
  char tuple_date[BUFSIZE];
} meeting_schedulePar;
typedef struct{
  CDATA date;
  char tuple_date[BUFSIZE];
} exchange_membersPar;
typedef struct{
  CDATA date;
  char tuple_date[BUFSIZE];
} collect_membersPar;
typedef struct{
  meeting_schedulePar meeting_schedule_par;
  exchange_membersPar exchange_members_par;
  collect_membersPar collect_members_par;
} LocalPar;
typedef struct{
  int wtype;
  int world;
  int sid;  int state[40];
  char *tid;
  LocalPar LPAR;
  SMessage start_msg;
} WorldInfo;

typedef struct {
  int  activity;
  int  subFd;
  char *agent_name;
  char *agent_id;
  struct {
    CDATA MyName;
    char *str_MyName;
    CDATA date;
    char tuple_date[BUFSIZE];
    CDATA others;
    char list_others[BUFSIZE];
  } CPAR;
} AgentInfo;

extern NPMethodData NPMethodList[];
extern AskProc askProc[];
extern NPInitFreeList npInitFreeList[];
extern AgentInfo agentInfo;
extern WorldInfo worldInfo[];
extern int worldID;
extern int ASKtoCALL(SMessage smg);
extern int QUERYtoASK(SMessage smg);
extern int REPLYtoRESULT(SMessage smg);
extern int RESULTtoREPLY(SMessage smg);
extern int ASKto_meeting_schedule(SMessage smg);
extern int meeting_schedule_toREPLY(SMessage smg);

extern int meeting_schedule_start_exchange_SubInfo_make_a_schedule(SMessage smg);
extern int exchange_members_init2_NegoProc_exchange_members(SMessage smg);
extern int collect_members_get_answer2_External_not_meeting(SMessage smg);

extern int ParaInit_meeting_schedule(void);
extern int ParaFree_meeting_schedule(void);
extern int ParaInit_exchange_members(void);
extern int ParaFree_exchange_members(void);
extern int ParaInit_collect_members(void);
extern int ParaFree_collect_members(void);

NPInitFreeList npInitFreeList[]={
  { meeting_schedule, ParaInit_meeting_schedule, ParaFree_meeting_schedule },
  { exchange_members, ParaInit_exchange_members, ParaFree_exchange_members },
  { collect_members, ParaInit_collect_members, ParaFree_collect_members },
  { -1, NULL, NULL }
};

NPMethodData MethodList[]={
  { ASK, MSGQ, NORMAL, QUERY_WAIT, ASKtoCALL, "want_member"},
  { ASK, MSGQ, NORMAL, QUERY_WAIT, ASKtoCALL, "exchange_member"},
  { ASK, MSGQ, NORMAL, QUERY_WAIT, ASKto_meeting_schedule, "scheuduling" },
  { REPLY, SIQ, NORMAL, NP_RUNNING, meeting_schedule_toREPLY, "scheuduling" },
  { ASK, SIQ, NORMAL, RUNNING, QUERYto_collect_members, "collect_members"},
  {REPLY, NPQ, NORMAL, NP_RUNNING, collect_members_toRESULT, "collect_members"},
  {REPLY, NPQ, NORMAL, RUNNING, RESULTtoREPLY, "utility"},
  {REPLY, NPQ, NORMAL, RUNNING, RESULTtoREPLY, "delete_member"},
  {REPLY, NPQ, NORMAL, RUNNING, RESULTtoREPLY, "scheduling"},
  {REPLY, NPQ, NORMAL, RUNNING, RESULTtoREPLY, "absentees"},
  { 0, 0, collect_members, collect_members_get_answer2, collect_members_get_answer2_External_not_meeting, "not_meeting"},
  { -1, 1, meeting_schedule, meeting_schedule_start_exchange, meeting_schedule_start_exchange_SubInfo_make_a_schedule, "make_a_schedule"},
  { 0, 2, exchange_members, exchange_members_init2, exchange_members_init2_NegoProc_exchange_members, "exchange_members"},
  {-1, -1, -1, -1, NULL, NULL}
};

AskProc askPro[]={
{NULL, NULL}
};

int ParaInit_meeting_schedule(void)
{
  char buffer[BUFSIZE];
  worldInfo[worldID].LPAR.meeting_schedule_par.others = NULL;
  worldInfo[worldID].LPAR.meeting_schedule_par.top = NULL;
  worldInfo[worldID].LPAR.meeting_schedule_par.next = NULL;
  worldInfo[worldID].LPAR.meeting_schedule_par.from = NULL;
  worldInfo[worldID].LPAR.meeting_schedule_par.date = NULL;
  return TRUE;
}

int ParaFree_meeting_schedule(void)
{
  if(worldInfo[worldID].LPAR.meeting_schedule_par.others == NULL)
    CDelete(worldInfo[worldID].LPAR.meeting_schedule_par.others);
  if(worldInfo[worldID].LPAR.meeting_schedule_par.top == NULL)
    CDelete(worldInfo[worldID].LPAR.meeting_schedule_par.top);
  if(worldInfo[worldID].LPAR.meeting_schedule_par.next == NULL)
    CDelete(worldInfo[worldID].LPAR.meeting_schedule_par.next);
  if(worldInfo[worldID].LPAR.meeting_schedule_par.from == NULL)
    CDelete(worldInfo[worldID].LPAR.meeting_schedule_par.from);
  if(worldInfo[worldID].LPAR.meeting_schedule_par.date == NULL)
    CDelete(worldInfo[worldID].LPAR.meeting_schedule_par.date);
  return 1;
}

int meeting_schedule_start_exchange_SubInfo_make_a_schedule(SMessage smg){
  char method[BUFSIZE];
  char to[BUFSIZE];
  char manage[BUFSIZE];
  char buffer[BUFSIZE];
  char data[BUFSIZE], *strPtr;
  char *sub_info;
  SMessage sendMsg;
  CDATA tmp0, tmp1;

  CDATA args;
  CDATA tmps;
  CDATA arg[2];
  char arg_str[BUFSIZE];
  char inner_method[BUFSIZE];
  args = CAPPSubstanceConvLocalCommon(CSMGetMethodStr(smg),
					     CSMGetDataStr(smg));
  tmp1 = CTGetElement(args, "#1");
  arg[0] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  tmp1 = CTGetElement(args, "#2");
  arg[1] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  CDelete(tmps);
  CDelete(args);
  sendMsg = CSMInit();

  if(WIlPar.meeting_schedule_par.date != NULL) CDelete(WIlPar.meeting_schedule_par.date);
  tmp0 = CDuplicate(arg[0]);
  WIlPar.meeting_schedule_par.date = CDuplicate(tmp0);
  CDelete(tmp0);
  if(    WIlPar.meeting_schedule_par.str_top = CBGetString(WIlPar.meeting_schedule_par.top),
    AIcPar.str_MyName = CBGetString(AIcPar.MyName),
    strcmp(WIlPar.meeting_schedule_par.str_top,AIcPar.str_MyName) == 0){
  strcpy(method, "exchange_members");
  memset(data, '\0', BUFSIZE);
  strPtr = data;
  tmp0 = CDuplicate(WIlPar.meeting_schedule_par.others);
  sprintf(strPtr, "%s", CStructToCommon(tmp0, arg_str));
  strPtr = strchr(strPtr, '\0');
  CDelete(tmp0);
  sprintf(strPtr, ",");
  strPtr = strchr(strPtr, '\0');
  sprintf(strPtr, "[");
  strPtr = strchr(strPtr, '\0');
  sprintf(strPtr, "]");
  strPtr = strchr(strPtr, '\0');
  sprintf(strPtr, ",");
  strPtr = strchr(strPtr, '\0');
  tmp0 = CDuplicate(WIlPar.meeting_schedule_par.next);
  sprintf(strPtr, "%s", CStructToCommon(tmp0, arg_str));
  strPtr = strchr(strPtr, '\0');
  CDelete(tmp0);
  sprintf(strPtr, ";");
  strPtr = strchr(strPtr, '\0');
  *(--strPtr) = '\0';

  sendMsg = MakeAskMessage("exchange_members", NULL, WItid, method, data);
  memset(buffer, '\0', BUFSIZE);
  sprintf(buffer, "%d", WIworld);
  CSMPutMidStr(sendMsg, buffer);
  WIstart_msg = sendMsg;
  WIPush(exchange_members, exchange_members_init, new_tid());
  sendMsg = CSMDuplicateMessage(sendMsg);
  CSMPutTidStr(sendMsg, WItid);
  CQEnqueue(NPQ, sendMsg);

    }
else{
  memset(to , '\0', BUFSIZE);
  memset(buffer , '\0', BUFSIZE);
  memset(manage, '\0', BUFSIZE);
  strPtr = buffer;
  sprintf(strPtr, "env ");
  strPtr = strchr(strPtr, '\0');
  CCommonToTOstring(buffer, to);
  strcpy(method, "test");
  memset(data, '\0', BUFSIZE);

  sendMsg = MakeAskMessage(to, manage, WItid, method, data);
  send_message(sendMsg);
    }
  WIChangeState(meeting_schedule_wait);

  if(WIstate == meeting_schedule_finish){
    WIPop();
  }
  return TRUE;
}
int ParaInit_exchange_members(void)
{
  char buffer[BUFSIZE];
  worldInfo[worldID].LPAR.exchange_members_par.date = NULL;
  return TRUE;
}

int ParaFree_exchange_members(void)
{
  if(worldInfo[worldID].LPAR.exchange_members_par.date == NULL)
    CDelete(worldInfo[worldID].LPAR.exchange_members_par.date);
  return 1;
}

int exchange_members_init2_NegoProc_exchange_members(SMessage smg){
  char method[BUFSIZE];
  char to[BUFSIZE];
  char manage[BUFSIZE];
  char buffer[BUFSIZE];
  char data[BUFSIZE], *strPtr;
  char *sub_info;
  SMessage sendMsg;
  CDATA tmp0, tmp1;

  char *str_3;
  CDATA args;
  CDATA tmps;
  CDATA arg[3];
  char arg_str[BUFSIZE];
  tmps = CCommonToStruct(CSMGetDataStr(smg));
  args = CCommonParse("#1:members,#2:members,#3:member", tmps);
  tmp1 = CTGetElement(args, "#1");
  arg[0] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  tmp1 = CTGetElement(args, "#2");
  arg[1] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  tmp1 = CTGetElement(args, "#3");
  arg[2] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  CDelete(tmps);
  CDelete(args);
  sendMsg = CSMInit();

  strcpy(method, "exchange_members");
  memset(data, '\0', BUFSIZE);
  strPtr = data;
  sprintf(strPtr, "true");
  strPtr = strchr(strPtr, '\0');
  sprintf(strPtr, ";");
  strPtr = strchr(strPtr, '\0');
  *(--strPtr) = '\0';

  sendMsg = MakeReplyMessage(data, WIstart_msg);
  CQEnqueue(NPQ, sendMsg);

  WIChangeState(exchange_members_finish);

  if(WIstate == exchange_members_finish){
    WIPop();
  }
  return TRUE;
}
int ParaInit_collect_members(void)
{
  char buffer[BUFSIZE];
  worldInfo[worldID].LPAR.collect_members_par.date = NULL;
  return TRUE;
}

int ParaFree_collect_members(void)
{
  if(worldInfo[worldID].LPAR.collect_members_par.date == NULL)
    CDelete(worldInfo[worldID].LPAR.collect_members_par.date);
  return 1;
}

int collect_members_get_answer2_External_not_meeting(SMessage smg){
  char method[BUFSIZE];
  char to[BUFSIZE];
  char manage[BUFSIZE];
  char data[BUFSIZE], *strPtr;
  char *sub_info;
  SMessage sendMsg;
  CDATA tmp0, tmp1;

  CDATA args;
  CDATA tmps;
  CDATA arg[1];
  char arg_str[BUFSIZE];
  sendMsg = MakeReplyMessage("<true>", smg);
  send_message(sendMsg);
  tmps = CCommonToStruct(CSMGetDataStr(smg));
  args = CCommonParse("#1:members", tmps);
  tmp1 = CTGetElement(args, "#1");
  arg[0] = CLGetElement(tmp1, 0);
  CDelete(tmp1);
  CDelete(tmps);
  CDelete(args);
  sendMsg = CSMInit();

  strcpy(method, "collect_members");
  memset(data, '\0', BUFSIZE);
  strPtr = data;
  tmp0 = CDuplicate(arg[0]);
  sprintf(strPtr, "%s", CStructToCommon(tmp0, arg_str));
  strPtr = strchr(strPtr, '\0');
  CDelete(tmp0);
  sprintf(strPtr, ";");
  strPtr = strchr(strPtr, '\0');
  *(--strPtr) = '\0';

  sendMsg = MakeReplyMessage(data, WIstart_msg);
  CQEnqueue(NPQ, sendMsg);

  WIChangeState(collect_members_finish);

  if(WIstate == collect_members_finish){
    WIPop();
  }
  return TRUE;
}

int ASKto_meeting_schedule(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  int world;
  int init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicate(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(MSGQ, new_smg);
  CREnqueue(smg, EXTERNAL, PROCEDURE, "meeting_schedule", worldID, ON);
  WIPush(meeting_schedule, meeting_schedule_init, tid);
  NP_ParaInit(meeting_schedule)();
  return TRUE;
}


int meeting_schedule_toREPLY(SMessage smg)
{
  CRNode node;
  SMessage reply_smg;

  CDelete(tmps);
  node = CRSelect(NULL, CSMGetMethodStr(smg), EXTERNAL, NEGO_PROC,
		  "meeting_schedule", worldID, ON);
  reply_smg = MakeReplyMessage(node->smg, CSMGetDataStr(data));
  send_message(reply_smg);
  free(data);
  CRNDelete(node);
  return TRUE;
}


int QUERYto_collect_members(SMessage smg)
{
  CDATA tmps;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  int world;
  char world_name[BUFSIZE];

  tmps = CAPSubstanceConLocalCommon("collect_members", CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDuplicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(SIQ, new_smg);
    CREnqueue(smg, SUBSTANCE, NEGO_PROC, "collect_members", worldID, Off);
    WIPush(collect_members, collect_members_init, tid);
    NP_ParaInit(collect_members)();
  }
  else{
    fprintf(stderr, "illegal data of method.\n");
    agentInfo.activity == EXIT;
  }
  return TRUE;
}


int collect_members_toRESULT(SMessage smg)
{
  CDATA tmps;
  char *data;
  CRNode node;

  tmps = CCommonToStruct(CSMGetDataStr(smg));
  data = CAPSubstanceConvCommonLocal(CSMGetMethodStr(smg), tmps);
  CDelete(tmps);
  node = CRSelect(NULL, CSMGetMethodStr(smg), SUBSTANCE, NEGO_PROC,
		  "collect_members", worldID, ON);
  PutResultToSubstance(data, node->query_id);
  CRNDelete(node);
  free(data);
  return TRUE;
}



int
  AIInit(char *agentName, char *agentID, int fd)
{
  agentInfo.subFd = fd;
  agentInfo.activity = ON;
  if(agentName != (char *)NULL)
    strcpy(agentInfo.agentName, agentName);
  if(agentID != (char *)NULL)
    strcpy(agentInfo.agentID, agentID);
  AICommonParInit();
  return TRUE;
}

void
  appHandleDebugFlag(SMessage smg)
{
  char		*method;

  if ((method = CSMGetMethodStr(smg)) != NULL) {
    if (!strcmp(method, "trace_on")) {
      CDebugFlagWrite(agentInfo.agentID, CSMGetFromAidStr(smg));
    } else if (!strcmp(method, "trace_off")) {
      CDebugFlagWrite(agentInfo.agentID, NULL);
    }
  }
}

int SelectWorldInit(int world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}

char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_SICStus_PIPE_substance(call);
  sprintf(procID, "%d", callID);
  return procID;
}

int
  PutResultToSubstance(char *procID, char *result)
{
  put_result_to_SICStus_PIPE_substance(result);
  return 0;
}

int
  ReceiveFromSubstance(SMessage smg)
{
  SMessage smg;
  char data[BUFSIZE], id[10];
  int  event;
  int  i;

  switch(event = getdata_SICStus_PIPE_substance(data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(record, data);
    if(WIstate == RUNNING){
      WIPushState(REPLY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, "illegal result request from substance");
      return event;
    }
    CRSetSubstanceReqFlagOn(record, data);
    smg = NULL;
    return event;
  case RESULT:
    smg = CSMInit();
    i = SelectConvLocalToCommon(SUBSTANCE_CALL, data);
    CSMTypeReply(smg);
    CSMPutMethodStr(smg, methodConvTable[i].commonMethod);
    CSMPutDataStr(smg, data);
    CSMPutMidStr(smg, id);
    CQEnqueue(SIQ, smg);
    return event;
  case QUERY:
    smg = CSMInit();
    i = SelectConvLocalToCommon(SUBSTANCE_QUERY, data);
    CSMTypeAsk(smg);
    CSMPutMethodStr(smg, methodConvTable[i].commonMethod);
    CSMPutDataStr(smg, data);
    CSMPutMidStr(smg, id);
    CQEnqueue(SIQ, smg);
    return event;
  case NO_DATA:
    smg = NULL;
    return event;
  default:
    fprintf(stderr, "capsule gets illegal data from substance\n");
    return NO_DATA;
  }
}

int
  PutResultToSubstance(char *procID, char *result)
{
  put_result_to_SICStus_PIPE_substance(result);
  return 0;
}

int
  ReceiveFromSubstance(SMessage *smg)
{
  char data[BUFSIZE], id[10];
  char sub_proc[BUFSIZE];
  char method[BUFSIZE];
  int  event;
  int  i;

  switch(event = getdata_from_SICStus_PIPE_substance(sub_proc, data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(id);
    if(WIstate == RUNNING){
      WIPushState(REPLY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, "illegal result request from substance");
      return event;
    }
    *smg = NULL;
    return event;
  case RESULT:
    SelectInnerMethod(CALL, sub_proc, method);
    CSMTypeReply(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case QUERY:
    SelectInnerMethod(QUERY, sub_proc, method);
    CSMTypeAsk(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case NO_DATA:
    *smg = NULL;
    return event;
  default:
    fprintf(stderr, "capsule gets illegal data from substance\n");
    return NO_DATA;
  }
}
