#include <stdio.h>
#include <SMessage.h>

extern char *PHYSICAL_AGENT_ID;
SMessage MakeAskMessage(char *to, char *manage, char *tid, char *method, char *data)
{
  SMessage smg;

  smg = CSMInit();
  CSMTypeAsk(smg);
  CSMPutFromAidStr(smg, PHYSICAL_AGENT_ID);
  CSMResetToMethod(smg);
  if(to != NULL || to[0] != '\0')
    CSMPutToAFStr(smg, to);
  if(manage != NULL || manage[0] != '\0')
    CSMPutToManagementStr(smg, manage);
  CSMPutMethodStr(smg, method);
  CSMPutTidStr(smg, tid);
  CSMPutMethodStr(smg, data);
  return smg;
}

SMessage MakeReplyMessage(char *data, SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "normal");
  CSMPutDataStr(replySmg, data);

  return replySmg;
}

SMessage MakeErrorMessage(SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "error");

  return replySmg;
}
  
