% $B<B$N=hM}$r8F$S=P$9$?$a$N=R8l(B
call_application(P) :-
%	current_predicate(_, P),
%	write(user_error, 'call_application('),
%	write(user_error, P),
%	write(user_error, ')'),
%	nl(user_error),
%	flush_output(user_error),
	call(P),
%	write(user_error, 'result:'), write(user_error, P), nl(user_error),
%	flush_output(user_error),
	functor(P, SUB_PROC, _),
	write('result:'),
	write(SUB_PROB),
	write('@'),
	write(P), nl,
	flush_output(user_output).

call_application(P) :-
%	write(user_error, 'result:fail'), nl(user_error),
%	flush_output(user_error),
	functor(P, SUB_PROC, _),
	write('result:'),
	write(SUB_PROC),
	write('@'),
	write('fail'), nl,
	flush_output(user_output).

% $B30It$X$NF14|Ld9g$;$N$?$a$N=R8l(B
% ex_query(Query) :-
% 	write('query:'), write(Query), nl,
% 	flush_output(user_output),
% 	read(query_id(ID)),
% 	write('request:'), write(ID), nl,
% 	flush_output(user_output),
% 	read(Reply),
% 	ex_query_check(Query, Reply).

ex_query(Query) :-
	functor(Query, SUB_PROC, _),
	write('query:'),
	write(SUB_PROC),
	write('@'),
	write(Query), nl,
	flush_output(user_output),
	read(ID),
	sub_ex_query(Query, ID).

sub_ex_query(Query, query_id(ID)) :-
	functor(Query, SUB_PROC, _),
	write('request:'),
	write(SUB_PROC),
	write('@'),
	write(ID), nl,
	flush_output(user_output),
	read(Reply),
	ex_query_check(Query, Reply).
sub_ex_query(Query, abort) :- !, abort.

ex_query_check(_, abort) :- !, abort.
ex_query_check(_, fail) :- !, fail.
ex_query_check(Query, Reply) :- Query = Reply, !.
ex_query_check(MyQuery, ExQuery) :-
	ExQuery,
	read(Reply),
	!,
	ex_query_check(MyQuery, Reply).

% $B30It$X$NHsF14|Ld9g$;$N$?$a$N=R8l(B
% ex_async_query(Query, ID) :-
% 	write('query:'), write(Query), nl,
% 	flush_output(user_output),
% 	read(query_id(ID)).

ex_async_query(Query, ID) :-
	functor(Query, SUB_PROC, _),
	write('query:'),
	write(SUB_PROC),
	write('@'),
	write(Query), nl,
	flush_output(user_output),
	read(Data),
	sub_ex_async_query(Query, Data).

sub_ex_async_query(_, query_id(ID)).
sub_ex_async_query(_, abort) :- abort.

% $B2r$N2s<}!"Hi$K(B ID $B$rEO$72r$r2s<}$9$k!#(B
ex_async_reply(ID, Query):-
	functor(Query, SUB_PROC, _),
	write('request:'),
	write(SUB_PROC),
	write('@'),
	write(ID), nl,
	flush_output(user_output),
	read(Reply),
	ex_async_query_check(ID, Query, Reply).

ex_async_query_check(_, _, abort) :- !, abort.
ex_async_query_check(_, _, fail) :- !, fail.
ex_async_query_check(_, Query, Reply) :- Query = Reply, !.
ex_async_query_check(ID, Query, ExQuery) :-
	ExQuery,
	read(Reply),
	!,
	ex_async_query_check(ID, Query, Reply).
