/* agentInfo.c
 *    module for handling an agent information.
 *
 */

#include <string.h>
#include <helios/SMessage.h>
#include "agentInfo.h"

AgentInfo agentInfo;
int
  AIInit(char *agentName, char *agentID, int fd)
{
  agentInfo.subFd = fd;
  agentInfo.activity = ON;
  if(agentName != (char *)NULL)
    strcpy(agentInfo.agentName, agentName);
  if(agentID != (char *)NULL)
    strcpy(agentInfo.agentID, agentID);
  AICommonParInit();
  return TRUE;
}

int
  AICommonParInit()
{
  agentInfo.cPar->ID = CommonDataInit(); /* capl$B$N5-=R$K$h$k(B */
  return TRUE;
}

void
  appHandleDebugFlag(SMessage smg)
{
    char		*method;

    if ((method = CSMGetMethodStr(smg)) != NULL) {
	if (!strcmp(method, "trace_on")) {
	    /* $B%H%l!<%9!&%U%i%0$rN)$F$k(B
	     */
	    CDebugFlagWrite(agentInfo.agentID, CSMGetFromAidStr(smg));
	} else if (!strcmp(method, "trace_off")) {
	    /* $B%H%l!<%9!&%U%i%0$r2<$m$9(B
	     */
	    CDebugFlagWrite(agentInfo.agentID, NULL);
	}
    }
}

/* end of agentInfo.c */
