/*   SMessage Handling Library           1994/05/25 Beta Version Release
                                         1994/06/12 Ver 1.0 Release
                                         1994/06/12 Ver 1.1 Release
                                            Method in 'TO' Field
                                         Designed by M.Sato
                                         Coded by M.Sato */

#define __SM_DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <helios/SMessage.h>
  
  
  SMessage CSMInit(){
    /*  SMessage$B$N<BBV$r:n$k!#(B*/
    
    SMessage message;
    
    message = malloc(sizeof(SMessage_m));

    if(message == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    }

    message-> mtype = NULL;
    message-> mid = NULL;
    message-> from = NULL;
    message-> to = NULL;
    message-> ts = NULL;
    message-> method = NULL;
    message-> data = NULL;

    return message;
    
  }


  SMessage CSMDelete(SMessage message){
  /*  SMessage$B$r>C5n$9$k!#$=$NFbMF$OA4$F>CLG$9$k!#;2>H$r;}$C$F$$$k>l9g$K(B
      $BCm0U$9$k$3$H!#(B*/
  
  if(CSMTypeFree(message)== NULL) return message ;
  if(CSMMidFree(message)== NULL) return message ;
  if(CSMFromFree(message)== NULL) return message ;
  if(CSMToFree(message)== NULL) return message ;
  if(CSMSMTSFree(message)== NULL) return message ;
  if(CSMMethodFree(message)== NULL) return message ;
  if(CSMDataFree(message)== NULL) return message ;
  
  free(message) ;
  
  return NULL ;
  
}

SMessage CSMNewData(SMType type ,SMMid mid ,SMFrom from,SMTo to ,
		    SMTS ts ,SMMethod method ,SMData data){
  /*  $B3F0z?t$rMWAG$K;}$D(B SMessage$B$r?7$?$K:n@.$9$k!#(BNULL$B$r0z?t$H$9$k$H!"(BSMessage
      $B$N$=$l$KBP1~$9$kMWAG$O6u$K$J$k!#(B*/
  
  SMessage message;
  
  message = CSMInit(); 
  
  return CSMPut(message,type,mid,from,to,ts,method,data); 
  
  
}


  SMessage CSMDuplicateMessage(SMessage smessage){
  /*  SMessage $B$rJ#@=$9$k!#(B*/
  
  SMessage message;
  
  message = CSMInit();
  
  
  return CSMPut(message ,CSMGetType(smessage),CSMGetMid(smessage), 
		CSMGetFrom(smessage),CSMGetTo(smessage),CSMGetSMTS(smessage),
		CSMGetMethod(smessage),CSMGetData(smessage));
  
  
}

  SMessage CSMPut(SMessage message ,SMType type ,SMMid mid ,SMFrom from ,SMTo to ,SMTS ts ,SMMethod method ,SMData data){
  /*  SMessage $B$N3FMWAG$K0z?t$G;XDj$5$l$?>pJs$rF~$l$k!#?7$?$J>pJs$rF~$l$k:]!"(B
      $B0JA0$NMWAG$NFbMF$O>C5n$5$l$k!#0z?t$,(BNULL$B$N>l9g$K$O!"0JA0$N>pJs$,;D$k!#(B*/  
  
  CSMPutType(message,type);
  CSMPutMid(message,mid);
  CSMPutFrom(message,from);
  CSMPutTo(message,to) ;
  CSMPutSMTS(message,ts);
  CSMPutMethod(message,method);
  CSMPutData(message,data);
  
  return message;
  
}

/*   int CSMGet(SMessage,*SMType,*SMMid,*SFrom,*STo,*STS,*SMethod,*SData){}
   
   SMessage $B$N3FMWAG$r;2>H$9$k!#0z?t$N(BSMessage$B$O=q$-49$($i$l$J$$!#(B
   $BLa$jCM$O!"3FMWAG$,<h$j=P$;$J$+$C$?>l9g(B(SMessage$B$K0[>o$,$"$k>l9g(B)$B$O(B1 
   $B@5>o$J$i(B0 $B$G$"$k!#(B*/


/* Message Type */

  SMType   CSMGetType(SMessage message){
  /*  SMessage$B$N%a%C%;!<%8%?%$%V>pJs$r;2>H$9$k!#(B*/
  
  if( message == NULL) return NULL;
  
  return message->mtype;
  
}

SMessage CSMPutType(SMessage message ,SMType type){
  /*SMessage$B$K%a%C%;!<%8%?%$%V>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  if( type == NULL) return NULL;
  
  if(CSMGetType(message) == NULL) {
    
    message->mtype = malloc(sizeof(SMType));
    
    if(message->mtype == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->mtype->debug = NULL;
      message->mtype->type = ASK;
    }
    
  }else if(message->mtype->debug != NULL){
    free(message->mtype->debug);
    message->mtype->debug = NULL;
  }
  
  if(CSPutDebuginfoStr(message->mtype,type->debug)== NULL) return NULL;
  
  if(CSPutType(CSMGetType(message),CSWhatType(type))== NULL) return NULL;
  
  return message;
}


  int     CSMIsTypeAsk(SMessage message ){
  /*  $B$=$N(BSMessage$B$,Ld$$9g$o$;$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  
  if( message == NULL) return NULL;
  
  return CSIsTypeAsk(CSMGetType(message));
}

  int    CSMIsTypeReply(SMessage message ){
  /*  $B$=$N(BSMessage$B$,JV?.$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  
  if( message == NULL) return NULL;
  
  return CSIsTypeReply(CSMGetType(message));
  
}

  int    CSMIsTypeControl(SMessage message){
  /*  $B$=$N(BSMessage$B$,%3%s%H%m!<%k$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  
  if( message == NULL) return NULL;
  
  return CSIsTypeControl(CSMGetType(message));
  
}
  int     CSMWhatType(SMessage message){
  /*  $B$=$N(BSMessage$B$,Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/
  
  if( message == NULL) return NULL;
  
  return CSWhatType(CSMGetType(message));
  
}

  SMessage CSMTypeAsk(SMessage message){
  /*  SMessage$B$N(BType$B$KLd$$9g$o$;$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  
  if(message->mtype == NULL)   {

    message->mtype = malloc(sizeof(SMType_m));

    if(message->mtype == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->mtype->debug = NULL;
      message->mtype->type = ASK;
    }

    CSPutDebuginfoStr(message->mtype,NULL);
  }
  if(CSPutType(CSMGetType(message),0) == NULL ) return NULL;
  
  return message;
}

  SMessage CSMTypeReply(SMessage message ){
  /*  SMessage$B$N(BType$B$KJV?.$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  if(message->mtype == NULL)   {
    message->mtype = malloc(sizeof(SMType_m));

    if(message->mtype == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->mtype->debug = NULL;
      message->mtype->type = ASK;
    }

    CSPutDebuginfoStr(CSMGetType(message),NULL);
  }
  
  if(CSPutType(CSMGetType(message),1) == NULL ) return NULL;
  
  return message;
}

  SMessage CSMTypeControl(SMessage message ){
  /*  SMessage$B$N(BType$B$K%3%s%H%m!<%k$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  if(message->mtype == NULL)   {
    message->mtype = malloc(sizeof(SMType_m));
    if(message->mtype == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->mtype->debug = NULL;
      message->mtype->type = NULL;
    }
    CSPutDebuginfoStr(CSMGetType(message),NULL);
  }
  
  if(CSPutType(CSMGetType(message),2) == NULL ) return NULL;
  
  return message;
}


  SMessage CSMPutDebuginfoStr(SMessage message ,char* username){
  /*  SMessage$B$K%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  if(CSMGetType(message) == NULL)   {
    message->mtype = malloc(sizeof(SMType_m));
    if(message->mtype == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->mtype->debug = NULL;
      message->mtype->type = NULL;
    }
  }
  
  if(CSPutDebuginfoStr(CSMGetType(message),username) == NULL ) return NULL;
  
  return message;
}


  char*    CSMGetDebuginfoStr(SMessage message){
  /*  SMessage$B$N%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$r;2>H$9$k!#(B
      $B%G%P%C%0>pJs$,$J$$>l9g$O!"(BNULL$B$,JV$5$l$k!#(B*/
  
  if( message == NULL) return NULL;
  if( CSMGetType(message) == NULL) return NULL;
  
  return CSGetDebuginfoStr(CSMGetType(message));
  
}

 SMessage CSMTypeFree(SMessage message) {
  /* SMType $B$r:o=|$9$k!#(B */
  
  if(message == NULL) return NULL;
  
  if(message->mtype != NULL) {
    free(message->mtype);
    message->mtype = NULL;
  }
  
  message->mtype = NULL;
  
  return message;
  
}

  int    CSIsTypeAsk(SMType mtype) {
  /*  $B$=$N(BSMType$B$,Ld$$9g$o$;$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  
  return (mtype->type == ASK);
  
}

  int    CSIsTypeReply(SMType mtype){
  /*  $B$=$N(BSMType$B$,JV?.$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  return (mtype->type == REPLY);
  
}

  int    CSIsTypeControl(SMType mtype){
  /*  $B$=$N(BSMessage$B$,%3%s%H%m!<%k$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/
  
  return mtype->type == CONTROL;
  
}

  int     CSWhatType(SMType mtype){
  /*  $B$=$N(BSMessage$B$,Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/
  
  if(mtype == NULL) return -1;
  
  return mtype->type;
}

  SMType  CSPutType(SMType mtype ,int type){
  /*  $B$=$N(BSMessage$B$,Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/
  
  mtype->type = type;
  
  return mtype;
}

  SMType CSPutDebuginfoStr(SMType mtype,char* username){
  /*  SMType$B$K%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/
  
  if(mtype == NULL) return NULL;
  
  if(mtype->debug != NULL) {
    free(mtype->debug);
    mtype->debug = NULL;
  }  

  if(username != NULL) {
    if((mtype->debug = (char*)strdup(username)) == NULL)
      return NULL;
  }else mtype->debug = NULL;

  
  return mtype;
  
}

  char*    CSGetDebuginfoStr(SMType mtype){
  /*  SMType$B$N%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$r;2>H$9$k!#(B
      $B%G%P%C%0>pJs$,$J$$>l9g$O!"(BNULL$B$,JV$5$l$k!#(B*/
  
  if(mtype == NULL) return NULL;
  
  return mtype->debug;
}


/* Message ID */

  SMessage CSMPutMid(SMessage message ,SMMid mid){
  /*SMessage$B$K(BMid$B$rF~$l$k!#(B 
    $B0z?t$N(BSMMid$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->mid != NULL) {
    free(message->mid);
    message->mid = NULL;
  }
  
  if(mid == NULL || *mid == '\0')
    message->mid = NULL;
  else
    message->mid = strdup((char*)mid);
  
  return message;
}

  SMMid    CSMGetMid(SMessage message ){
  /*  SMessage$B$N(BMid$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BMid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BMid$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return message->mid;
  
}

  SMessage CSMPutMidStr(SMessage message,char * mid){
  /*  SMessage$B$N(BMid$B$N>pJs$r(BString$B$GF~$l$k!#(B
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B */
  
  return CSMPutMid(message,mid);
}

  char*    CSMGetMidStr(SMessage message){
  /*  SMessage$B$N(BMid$B>pJs$r(BString$B$H$7$F;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(Bstring$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B */
  
  return CSMGetMid(message);
  
}

  SMessage CSMPutMidStrInt(SMessage message,char * aid, int num){
  /*  SMessage$B$N(BMid$B$N(BAid$BItJ,$HDL$7HV9f>pJs$rF~$l$k!#(BAid$B$O(BC $B8@8l$N(Bstring$B$G$"$k!#(B
      string$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->mid != NULL) {
    free(message->mid);
    message->mid = NULL;
  }
  
  message->mid = malloc(strlen(aid)+10);
    if(message->mid == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    }

  sprintf(message->mid,"%s_%d",aid,num);
  
  return message;
}


 SMessage CSMMidFree(SMessage message) {
  
  if(message == NULL) return NULL;
  
  if(message->mid != NULL) {
    free(message->mid);
    message->mid = NULL;
  }
  
  return message;
}


/* From */

  SMessage CSMPutFrom(SMessage message,SMFrom mfrom){
  /*SMessage$B$K(BSMFrom$B$rF~$l$k!#(B 
    $B0z?t$N(BSMFrom$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  return CSMPutFromAidStr( message,(char*)mfrom);
  
}
  SMFrom   CSMGetFrom(SMessage message){
  /*  SMessage$B$N(BFrom$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BSMFrom$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  return (SMFrom)message->from;
}

  SMessage CSMPutFromAidStr(SMessage message,char * aid){
  /*  SMessage$B$N(BFrom$B$N(BAid$B$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  if(CSMGetFrom(message) != NULL) {
    free(message->from); 
    message->from = NULL;
  }

  if(aid == NULL || *aid == '\0')
    message->from = NULL;
  else
    if((message -> from = strdup(aid)) == NULL) return NULL;
  
  return message;

}

  char*    CSMGetFromAidStr(SMessage message){
  /*  SMessage$B$N(BFrom$B$N(BAid$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BAid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  return CSGetFromAidStr(CSMGetFrom(message));
  
}

 SMessage CSMFromFree(SMessage message){
  
  if(message == NULL) return NULL;
  if(message->from == NULL) return message;
  
  free(message->from);
  message->from = NULL;
  
  return message;
  
}

/*    SMFrom   CSPutFromAidStr(SMFrom mfrom,char * aid){} */
/*  SMFrom$B$N(BAid$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/


  char *   CSGetFromAidStr(SMFrom mfrom){
  /*  SMFrom$B$N(BFrom$B$N(BAid$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BAid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mfrom;
  
}


/* To */

  SMessage CSMPutTo(SMessage message,SMTo mto){
  /*SMessage$B$K(BTo$B$rF~$l$k!#(B 
    $B0z?t$N(BSMTo$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->to != NULL) {
    if(message->to->AF != NULL) {
      free(message->to->AF);
      message->to->AF = NULL;
    }
    if(message->to->management != NULL){
      free(message->to->management);
      message->to->management = NULL;
    }
  } else {
    message->to = malloc(sizeof(SMTo_m));
    if(message->to == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    }else {
      message->to->AF = NULL;
      message->to->method = 0;
      message->to->management = NULL;
    }
  }
  
  
  if(CSPutToAFStr(message->to,mto->AF) == NULL ) return NULL;


  if(CSPutToManagementStr(message->to,mto->management)
     == NULL ) return NULL;

  message->to->method = mto->method;
  return message;
}

  SMTo    CSMGetTo(SMessage message){
  /*  SMessage$B$N(BTo$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return message->to;
  
}

  SMessage CSMPutToAFStr(SMessage message,char * aid){
  /*  SMessage$B$N(BTo$B$N(BAid$B$^$?$O5!G=L>$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  if(message->to == NULL){
    message->to = malloc(sizeof(SMTo_m));
    if(message->to == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    }else {
      message->to->AF = NULL;
      message->to->management = NULL;
      message ->to->method = 0;
    }
  }
  
  if( aid == NULL || *aid == '\0')
    message->to->AF = NULL;
  else
    message->to->AF = strdup(aid);

  return message;   
  
}


  char*    CSMGetToAFStr(SMessage message){
  /*  SMessage$B$N(BTo$B$N(BAid$B$^$?$O5!G=L>$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->to == NULL) return NULL; 

  return (char*)message->to->AF;
  
}


     SMessage CSMSetToMethod(SMessage message){
/*  SMessage$B$N(BTo$B$K%a%=%C%I%U%#!<%k%I$HF1$8J8;zNs>pJs$,<h$j=P$;$kMM$K(B
  $B@_Dj$9$k!#$3$l$O!"%a%=%C%I%G%#%l%/%H%j$r;H$&$h$&$K$9$k@_Dj$G$"$k!#(B*/

  if(message == NULL) return NULL;
  
  if(CSMGetTo(message) == NULL) {
    message->to = malloc(sizeof(SMTo_m));
    if(message->to == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->to->AF = NULL;
      message->to->management = NULL;
      message ->to->method = 0;
    }
  }

 message ->to->method = 1;

return message;

}

     SMessage CSMResetToMethod(SMessage message){
/*  SMessage$B$N(BTo$B$+$i%a%=%C%IL>$,<h$j=P$;$J$$MM$K@_Dj$9$k!#(B
    $B$3$l$O!"%a%=%C%I%G%#%l%/%H%j$r;H$&$h$&$K$9$k@_Dj$G$"$k!#(B*/

  if(message == NULL) return NULL;
  
  if(CSMGetTo(message) == NULL) {
    message->to = malloc(sizeof(SMTo_m));
    if(message->to == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->to->AF = NULL;
      message->to->management = NULL;
      message ->to->method = 0;
    }
  }

message ->to->method = 0;

return message;

}

     char*    CSMGetToMethodStr(SMessage message){
/*  SMessage$B$N(BTo$B$N%a%=%C%IL>$r;2>H$9$k!#(B
  $BLa$jCM$O!"%a%C%;!<%8Cf$N%a%=%C%IL>$G$"$k!#(B
  $BLa$jCM$,(BNULL$B$N;~$O!"%a%=%C%I%G%#%l%/%H%j$r;HMQ$7$J$$!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


   if(message->to == NULL) return NULL;

   if(message->to->method)
     return CSMGetMethodStr(message);
   else
     return NULL;
 }


  SMessage CSMPutToManagementStr(SMessage message,char* manage){
  /*  SMessage$B$N(BTo$B$N=hM}L>$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(CSMGetTo(message) == NULL) {
    message->to = malloc(sizeof(SMTo_m));
    if(message->to == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    } else {
      message->to->AF = NULL;
      message->to->management = NULL;
      message ->to->method = 0;
    }
  }
  
  if(manage == NULL || *manage == '\0')
    message->to->management = NULL;
  else
    message->to->management = strdup(manage);
  
  return message;

}
  char*    CSMGetToManagementStr(SMessage message){
  /*  SMessage$B$N(BTo$B$N=hM}L>$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  if(CSMGetTo(message) == NULL) return NULL;
  
  return CSGetToManagementStr(CSMGetTo(message));
  
}

 SMessage CSMToFree(SMessage message){
  
  if(message == NULL) return NULL;
  if(message->to == NULL) return message;
  
  if(message->to->AF != NULL) {
    free(message->to->AF);
    message->to->AF = NULL;
  }
  if(message->to->management != NULL) {
    free(message->to->management);
    message->to->management = NULL;
  }
  
  free(message->to);
  message->to = NULL;
  
  return message;
}

  SMTo CSPutToAFStr(SMTo mto ,char * aid){
  /*  SMTo$B$N(BAid$B$^$?$O5!G=L>$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(CSGetToAFStr(mto) != NULL) {
    free(mto->AF);
    mto->AF = NULL;
    mto->method = 0;
  }
  

  if(aid == NULL) {
    mto->AF = NULL;
  }else
    {
      if((mto->AF = strdup(aid))== NULL)
	return NULL;
    }
  return mto;
}
  char*    CSGetToAFStr(SMTo mto){
  /*  SMTo$B$N(BAid$B$^$?$O5!G=L>$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(mto == NULL) return NULL;
  
  return mto->AF;
  
}
  SMTo CSPutToManagementStr(SMTo mto ,char* manage){
  /*  SMTo$B$N=hM}L>$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(CSGetToManagementStr(mto) != NULL) {
    free(mto->management);
    mto->management = NULL;
  }
  
  if(manage == NULL) {
    mto->management = NULL;
  } else {
    if((mto->management = strdup(manage))== NULL) return NULL;
  }
  return mto;
  
}
  char*    CSGetToManagementStr(SMTo mto){
  /*  SMTo$B$N=hM}L>$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mto->management;
}



/* Status or Transaction ID */

  SMessage CSMPutSMTS(SMessage message,SMTS mts){
  /*SMessage$B$N(BSMTS$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BSTS$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(mts == NULL || *mts == '\0') {
    message->ts = NULL;
    return message;
  }

  if(mts == NULL || *mts == '\0')
    message->ts = NULL;
  else
    if((message->ts = strdup(mts)) == NULL) return NULL;
  
  return message;
  
}
  SMTS     CSMGetSMTS(SMessage message){
  /*  SMessage$B$N(BSMTS$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return message->ts;
  
  
}

  SMessage CSMPutTidStr(SMessage message,char* mtid){
  /*  SMessage$B$N(BTid$B$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
      SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/
  
/*   if(!CSMIsTypeAsk(message))    return NULL; */
  
  if(mtid == NULL || *mtid == '\0') {
    message->ts = NULL;
    return message;
  }


  if(mtid == NULL || *mtid == '\0')
    message->ts = NULL;
  else
    if((message->ts = strdup(mtid)) == NULL) return NULL;
  
  return message;
  
}

  SMessage CSMPutTidStrInt(SMessage message,char* mtid,int n){
  /*  SMessage$B$N(BTid$B$K(BAid$B$H(BLocal Tid$B>pJs$rF~$l$k!#(B 
      $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
      SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/
  
/*   if(!CSMIsTypeAsk(message))    return NULL; */
  
  message->ts = malloc(strlen(mtid)+10);
    if(message->ts == NULL) {
      fputs(stderr,"SMessage:malloc fail\n");
      return NULL;
    }
  
  sprintf(message->ts,"%s_%d",mtid,n);
  
  return message;
  
}

  char*   CSMGetTidStr(SMessage message){
  /*  SMessage$B$N(BTid$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B
      SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/
  
/*   if(!CSMIsTypeAsk(message))    return NULL; */
  
  return CSGetTidStr(message->ts);
}

  SMessage CSMPutStatusStr(SMessage message,char* mstatus){
  /*  SMessage$B$N(BStatus$B$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(BSMTS$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
      SMessage$B$,JV?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/
  
/*   if(!CSMIsTypeReply(message))    return NULL; */
  
  if(mstatus == NULL || *mstatus == '\0')
    message->ts = NULL;
  else
  if((message->ts = strdup(mstatus)) == NULL) return NULL;
  
  return message;
}


  char*    CSMGetStatusStr(SMessage message){
  /*  SMessage$B$N(BStasus$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B
      SMessage$B$,JV?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/
  
/*   if(!CSMIsTypeReply(message))    return NULL; */
  
  return message->ts;
  
}

 SMessage CSMSMTSFree(SMessage message){
  
  if(message == NULL) return NULL;
  
  if(message->ts == NULL) return message;
  
  free(message->ts);
  message->ts = NULL;
  
  return message;
}


/*   SMTS CSPutTidStr(SMTS mts,char* mtid){} */
/*  SMTS$B$r(BTid$B$H$7$F>pJs$rF~$l$k!#(B 
    $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

  char*    CSGetTidStr(SMTS mts){
  /*  SMTS$B$r(BTid$B$H$_$F>pJs$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mts;
  
}
/*    SMTS CSPutStatusStr(SMTS mts,char* status){} */
/*  SMTS$B$N(BStatus$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/


  char*    CSGetStatusStr(SMTS mts){
  /*  SMTS$B$r(BStatus$B$H$7$F>pJs$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mts;
  
}
/* Method Name*/

  SMessage CSMPutMethod(SMessage message,SMMethod mmethod){
  /*SMessage$B$N(BMethod Name$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BSMMethod$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->method != NULL) {
    free(message->method);
    message->method = NULL;
  }
  
  
  if(mmethod == NULL || *mmethod == '\0')
    message->method = NULL;
  else
  if((message->method = strdup(mmethod)) == NULL) return NULL;
  
  return message;
  
}

  SMMethod CSMGetMethod(SMessage message){
  /*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return message->method;
  
}

  SMessage CSMPutMethodStr(SMessage message,char* mmethod){
  /*  SMessage$B$N(BMethod Name$B$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL )  return NULL;

/*
#ifdef __SM_DEBUG

  puts("SMessage : Set Method  ");
  puts(mmethod);
  puts("\n\n");

   if(strcmp(mmethod,"normal") == 0) {

    puts("Illigal Method !!!!!!!!!!!! normal");
  }

 if(mmethod == NULL || *mmethod == '\0') {

    puts("SMessage ::Illigal Method !!!!\n");
    puts("           Method must not be NULL string\n\n");

  }  
#endif __SM_DEBUG
*/

  if(CSMGetMethodStr(message) != NULL) {
    free(message->method);
    message->method = NULL;
  }

  if(mmethod == NULL || *mmethod == '\0')
    message->method = NULL;
  else
  if((message->method = strdup(mmethod)) == NULL) return NULL;
  
  return message;
  
}
  char*    CSMGetMethodStr(SMessage message){
  /*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return CSGetMethodStr(message->method);
  
  
}


 SMessage CSMMethodFree(SMessage message){
  
  if(message == NULL) return NULL;
  
  if(message->method == NULL) return message;
  
  free(message->method);
  message->method = NULL;
  
  return message;
}






/*   SMMethod CSPutMethodStr(SMMethod mmethod ,char* method){} */
/*  SMMethod$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

  char*    CSGetMethodStr(SMMethod mmethod){
  /*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mmethod;
  
}

/*   Data  */

  SMessage CSMPutData(SMessage message,SMData mdata){
  /*SMessage$B$N(BData$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BSMMethod$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(message->data != NULL) {
    free(message->data);
    message->data = NULL;
  }

  if(mdata == NULL || *mdata == '\0')
    message->data = NULL;
  else
  if((message->data = strdup(mdata)) == NULL) return NULL;
  
  return message;
  
}
  SMData   CSMGetData(SMessage message){
  /*  SMessage$B$N(BData$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return message->data;
  
}
  SMessage CSMPutDataStr(SMessage message,char* data){
  /*  SMessage$B$N(BData$B$K>pJs$rF~$l$k!#(B 
      $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/
  
  if(message == NULL) return NULL;
  
  if(data == NULL || *data == '\0')
    message->data = NULL;
  else
    if((message->data =strdup(data)) == NULL) return NULL;
  
  return message;
  
}
  char*    CSMGetDataStr(SMessage message){
  /*  SMessage$B$N(BData$B$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  if(message == NULL) return NULL;
  
  return CSGetDataStr(CSMGetData(message));
  
}


 SMessage CSMDataFree(SMessage message){
  
  if(message == NULL) return NULL;
  
  if(message->data == NULL) return message;
  
  free(message->data);
  message->data = NULL;
  
  return message;
}



/*    SMData   CSPutDataStr(SMData mdata ,char* data){} */
/*  SMData$B$K>pJs$rF~$l$k!#(B 
    $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

  char*    CSGetDataStr(SMData mdata){
  /*  SMData$B$N>pJs$r;2>H$9$k!#(B
      $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
      $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/
  
  return mdata;
  
}
