/* CRecord.c
 *        $B30It!&<B!&<jB3$-$+$i$NLd$$9g$o$;$KBP$9$k=hM}$r5-O?$9$k!#(B
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "CRecord.h"

static CRecord record;

CRecord
  CRecordNew(void)
{
  CRecord new;

  new = (CRecord)malloc(sizeof(CRecordM));
  new->head = (CRNode)NULL;
  new->tail = (CRNode)NULL;
  return new;
}

int
  CRecordInit()
{
  CRNFree(record->head);
  record->head = (CRNode)NULL;
  record->tail = (CRNode)NULL;
  return 0;
}

int
  CREnqueue(SMessage smg, int src, int dist,
	    char *procID, int worldID, int flag)
{
  CRNode new, tail;
  new = CRNNew(smg, src, dist, procID, worldID, flag);
  tail = record->tail;
  new->front = tail;
  new->rear = (CRNode)NULL;
  tail->rear = new;
  return 0;
}

CRNode CRSelect(char *mid, char *method, int src, int dist,
		char *procID, int worldID, int flag)
{
  CRNode node;

  node = CRNSelect(record->head, mid, method,
		   src, dist, procID, worldID, flag);
  return node;
}

int CRSetSubstanceReqFlagOn(char *methodID)
{
  CRNode node;
  node = CRNSelect(record->head, (char *)NULL, methodID,
		   SUBSTANCE, -1, (char *)NULL, -1, OFF);
  if(node != (CRNode)NULL){
    node->reqFlag = ON;
    return TRUE;
  }
  else{
    return FAIL;
  }
}


/* end of CRecord.c */
