/* CRNode.c
 *    module for handling nodes of a record in capsule.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <helios/SMessage.h>
#include "CRNode.h"

CRNode
  CRNNew(SMessage smg, int src, int dist,
	 char *procID, int worldID, int flag)
{
  CRNode new;

  new = (CRNode)malloc(sizeof(CRNodeM));
  new->smg = smg;
  strcpy(new->procID, procID);
  new->src = src;
  new->dist = dist;
  new->worldID = worldID;
  new->reqFlag = flag;
  new->front = (CRNode)NULL;
  new->rear = (CRNode)NULL;
  return new;
}

int
  CRNFree(CRNode node)
{
  if(node != (CRNode)NULL){
    CRNFree(node->rear);
  }
  free(node);
  return 0;
}

int
  CRNDelete(CRNode node)
{
  if(node != (CRNode)NULL){
    if(node->front != (CRNode)NULL){
      node->front->rear = node->rear;
    }
    if(node->rear != (CRNode)NULL){
      node->rear->front = node->rear;
    }
    free(node);
  }
  return 0;
}

CRNode
  CRNSelect(CRNode node, char *methodID, char *method,
	    int src, int dist, char *procID,
	    int worldID, int reqFlag)
{
  int flag;

  flag = 0;
  if(node != (CRNode)NULL){
    if(method != (char *)NULL
       && strcmp(method, CSMGetMethodStr(node->smg)) != 0) flag = 1;

    if(flag == 0 && methodID != (char *)NULL
       && strcmp(methodID, CSMGetMidStr(node->smg)) != 0) flag = 1;

    if(flag == 0 && src != -1 && src != node->src) flag = 1;
    if(flag == 0 && dist != -1 && dist != node->dist) flag = 1;

    if(flag == 0 && procID != (char *)NULL
       && strcmp(procID, node->procID) != 0) flag = 1;

    if(flag == 0 && worldID != -1 && worldID != node->worldID) flag = 1;
    if(flag == 0 && reqFlag != -1 && reqFlag != node->reqFlag) flag = 1;
    if(flag == 0)
      return node;
    else{
      return CRNSelect(node->rear, methodID, method, 
		       src, dist, procID, worldID, reqFlag);
    }
  }
  else{
    return (CRNode)NULL;
  }
}

/* end of CRNode.c */
