/* CQueue.c
 *    module of capl compiler for handling a queue in capsule.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <helios/CaplDef.h>
#include "CQueue.h"

static CQueue queue[3];

void CQNew(int i)
{
  for(i = 0; i < 3; i++){
    queue[i] = (CQueue)malloc(sizeof(CQueueM));
    queue[i]->head = (CQNode)NULL;
    queue[i]->tail = (CQNode)NULL;
  }
}

int
  CQEmpty(int id)
{
  if(queue[id]->head == (CQNode)NULL && queue[id]->tail == (CQNode)NULL)
    return TRUE;
  else
    return NULL;
}

int
  CQEnqueue(int id, SMessage smg)
{
  CQNode new, tail;

  tail = queue[id]->tail;
  new = CQNodeNew(smg);
  new->front = tail;
  new->rear = (CQNode)NULL;
  tail->rear = new;
  return TRUE;
}

SMessage
  CQDequeue(int id, int type, char* mid, char* tid, char *method)
{
  CQNode node;
  SMessage smg;
  node = CQNSelect(queue[id]->head, type, mid, tid, method);
  if(node != NULL){
    smg = node->smg;
    CQNodeDelete(node);
    return smg;
  }
  else{
    return (SMessage)smg;
  }
}

/* end of CQueue.c */
