/* CQNode.c
 *    a module of capl compiler for handling nodes of a queue in capsule.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <helios/SMessage.h>
#include "CQNode.h"

CQNode CQNodeNew(SMessage smg)
{
  CQNode new;

  new = (CQNode)malloc(sizeof(CQNodeM));
  if(new == NULL){
    fprintf(stderr, "fail of malloc in CQNodeNew().\n");
    exit(1);
  }
  new->smg = smg;
  new->front = (CQNode)NULL;
  new->rear  = (CQNode)NULL;
  return new;
}

int
  CQNodeFree(CQNode node)
{
  if(node->rear != (CQNode)NULL){
    CQNodeFree(node->rear);
  }
  free(node);
  return 0;
}

int
  CQNodeDelete(CQNode node)
{
  if(node != (CQNode)NULL){
    if(node->front != (CQNode)NULL){
      node->front->rear = node->rear;
    }
    if(node->rear != (CQNode)NULL){
      node->rear->front = node->front;
    }
    free(node);
  }
  return 0;
}

CQNode
  CQNSelect(CQNode node, int type, char *mid, char *tid, char *method)
{
  SMessage message;
  int flag;

  flag = 0;
  if(node != NULL){
    message = node->smg;
    if(flag == 0 && type >= 0 && CSMWhatType(message) != type) flag = 1;

    if(flag == 0 && mid != NULL){
      if(strcmp(CSMGetMidStr(message), mid) == 0) flag = 1;
    }
    if(flag == 0 && tid != NULL){
      if(CSMIsTypeAsk(message) == NULL) flag = 1;
      else {
	if(CSMGetTidStr(message) == NULL) flag = 1;
	if(strcmp(CSMGetTidStr(message), tid) != NULL) flag = 1;
      }
    }
    if(flag == 0 && method != NULL){
      if(strcmp(CSMGetMethodStr(message), method) == 0) flag = 1;
    }
    if(flag == 1){
      return CQNSelect(node->rear, type, mid, tid, method);
    }
    else{
      return node;
    }
  }
  else{
    return (CQNode)NULL;
  }
  }

/* end of CQNode.c */
