/*
 * CAPofSICSagent.c
 * $B%Q%$%W$G%G!<%?$N8r49$r9T$J$&(B Prolog $B$r<B$H$9$k>l9g$N!"(B
 * $BHi$H<B$N@\B3ItJ,(B
 * $BJQ99ItJ,(B
 *   $BHsF14|Ld9g$;$X$NBP1~(B
 * 1994.07.05 by S.WAZUMI
 */

#define __CAPofSICSagent__

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>

#include <unistd.h>
#include <vfork.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <helios/event.h>

#include <helios/SICStus_sub_cap.h>

#define INT_MAX 1000

static char call_load[] = "[../../../substance/call.pl].\n";
static data_table data_type[] = {
  QUERY,   "query:",   6,
  RESULT,  "result:",  7,
  REQUEST, "request:", 8,
  ILLEGAL, (char *)NULL, 0 };

static fd_set mask, readfds;
static int width;
static int pipe_1[2], pipe_2[2];

static int  pid;
static int  call_id  = 0;
static int  query_id = 0;
static char *buf;

/* $B%F%9%HMQ4X?t(B */
/* $BDL?.It$,Ds6!$9$k(B */

static char *check_data_type(char *buf, data_table dt);

int init_SICStup_substance(char *path, char *agent_name, char *substance)
{
  char file[100];
  
  /* $B<B$HHi$NDL?.$N$?$a!"%Q%$%W$r3+$/(B */
  if(pipe(pipe_1) < 0){
    perror("pipe");
    return -1;
  }
  
  if(pipe(pipe_2) < 0){
    perror("pipe");
    return -1;
  }
  
  if((pid = fork()) <0){
    perror("fork");
    return -1;
  }
  
  /* $B;R%W%m%;%9$H$7$F<B$H$J$k(B Prolog $B$r5/F0$9$k(B */
  if(pid == 0){
    close(0);
    dup(pipe_1[0]);
    close(pipe_1[0]);
    close(1);
    dup(pipe_2[1]);
    close(pipe_2[1]);
    
    close(pipe_2[0]);
    close(pipe_1[1]);
#ifdef SUB
#else
    close(2);
#endif
    sprintf(file, "%s/%s", path, SIStus);
    execl(file, agent_name, "-l", substance_name, NULL, 0);
  }
  close(pipe_1[0]);
  close(pipe_2[1]);

  write(pipe_1[1], call_load, strlen(call_load));
  /* $BDL?.It$K(B pipe_2[0] $B$+$i$NF~NO$r%$%Y%s%H$H$7$FEPO?$9$k(B */
  register_fd(pipe_2[0], FD_EV_READ);
  
  return pipe_2[0];
}

int close_SICStus_substance(void)
{
  write(pipe_1[1], "halt.\n", strlen("halt.\n"));
  /* $B<B$HHi$N4V$N%Q%$%W$rJD$8$k(B */
  close(pipe_1[1]);
  close(pipe_2[0]);
  
  while(wait((int *) 0) != pid);
  /*  wait(); */
  return 0;
}

/*
  $B<B$N=hM}$N8F$S=P$7(B
  $B=hM}A*Br$d7?JQ49$G8F$S=P$7$?$$=R8l$N7A$K$^$GJQ49$5$l$F$$$k$b$N$H$9$k!#(B
  */

int call_SICStup_application(char *predicate)
{
  write(pipe_1[1], "call_application(", strlen("call_application("));
  write(pipe_1[1], predicate, strlen(predicate));
  write(pipe_1[1], ").\n", strlen(").\n"));
  if(call_id >= INT_MAX){
    call_id = 0;
  }
  return ++call_id;
}

int exit_SICStus_substance(void)
{
  /* $BJV?.BT$A$N<B$b=*N;$5$;$k$?$a!":G=i$K(B abort $B$r<B$KAw$k!#(B */
  /* abort $B$K$h$j(B Prolog $B$N=hM}$,=*N;$7$?;~E@$G(B halt $B$rAw$k!#(B*/
  write(pipe_1[1], "abort.\n", strlen("abort.\n"));
  write(pipe_1[1], "halt.\n", strlen("halt.\n"));
  
  /* $B<B$HHi$N4V$N%Q%$%W$rJD$8$k(B */
  close(pipe_1[1]);
  close(pipe_2[0]);
  
  while(wait((int *) 0) != pid);
  return 0;
}

int put_result_to_SICStup_application(char *result)
{
  if(write(pipe_1[1], result, strlen(result)) >= 0){
    if(write(pipe_1[1], ".\n", strlen(".\n")) >= 0){
      query_id--;
      return 1;
    } else {
      return 0;
    }
  } else {
    return 0;
  }
}

/*
 * $B<B$+$i$N%G!<%?$N<u$1<h$j(B
 */
int get_data_from_SICStup_application(char *sub_proc, char *data, char *id)
{
  int i, n;
  static int query_id = 0;
  char query[20];
  static int flag = 0;
  static char buf[BUF_LEN], *head, *tail, *tmp, *sep;
  
  if(flag == 0){
    memset(buf, 0, BUF_LEN);
    n = read(pipe_2[0], buf, BUF_LEN);
    if(n == 0){
      return SUICIDE;
    } else if(n < 0){
      return SUB_ERROR;
    } else {
      head = buf;
      flag = 1;
    }
  }
  tail = strchr(head, '\n');
  if(tail != NULL){
    for(tmp = head, *tail = '\0', i = 0; data_type[i].id != (char *)NULL; i++){
      if((head = check_data_type(tmp, data_type[i])) != NULL){
	sep = strchr(head, '@');
	*sep++ = '\0';
	strcpy(sub_proc, head);
	strcpy(data, sep);
	break;
      }
    }
    if(*(tail + 1) == NULL){
      head = tail - 1;
    }
    else{
      head = tail + 1;
    }
    if(data_type[i].type == QUERY){
      sprintf(id, "%d", query_id++);
      sprintf(query, "query_id(%s).\n", id);
      write(pipe_1[1], query, strlen(query));
    }
    else if(data_type[i].type == REQUEST){
      sprintf(id, "%s", data);
    }
    return data_type[i].type;
  } else {
    flag = 0;
    return NO_DATA;
  }
}

/*
  $B<B$+$i$N%G!<%?$N<u$1<h$j$N8!=P(B
  */
int check_data_from_application(void)
{
  int i, j, n;
  char tmp[BUF_LEN], *head;
  
  n = read(pipe_2[0], tmp, BUF_LEN);
  *(tmp+n-1) = '\0';
  for(i = 0; data_type[i].id != (char *)NULL; i++) {
    if((head = check_data_type(tmp, data_type[i])) != NULL) {
      break;
    }
  }
  if(buf != (char *)NULL) free(buf);
  if(data_type[i].id != (char *)NULL) {
    buf = (char *)malloc(sizeof(char) * (n - data_type[i].len + 1));
    for(j = 0; j < (n - data_type[i].len); j++) {
      *(buf+j) = tmp[data_type[i].len +j];
    }
    *(buf+j) = '\0';
    return data_type[i].type;
  } else {
    buf = NULL;
    return data_type[i].type;
  }
}

static char *check_data_type(char *buf, data_table dt)
{
  char *head;
  
  head = buf;
  while(*buf == *dt.id) {
    buf++;
    dt.id++;
  }
  if(*dt.id == '\0') {
    return buf;
  } else {
    return (char *)NULL;
  }
}

/* end of CAPofSICSagent.c */
