/* CAPofENV.c
 *
 * $Id: CAPofENV.c,v 1.13 1994/10/20 07:11:06 k3sato Exp $
 */
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <helios/SMessage.h>
#include <helios/AgentFlags.h>
#include <helios/CAPofENV.h>
#include <helios/dprintf.h>
#include <helios/debugInfo.h>


int CheckDebugWrite(char* AgentID,SMessage Message);

extern SMessage CoETransfer(char* AgentID,SMessage Message,int Mode);


SMessage CapOfEnv(char* AgentID,SMessage Message,int Mode){
  

  if(CheckDebugWrite(AgentID,Message) ) {
               /* Control Type Message */
    return Message;

  } else {
               /* Ask/Reply Messaage */
    return  CoETransfer(AgentID,Message,Mode);
  }
}


int  CheckDebugWrite(char* AgentID,SMessage Message) {
  
  char *User,*Method;

  int r;
  
  r = 0;

  /* Check Debug Flag Control Message */
  
  if(CSMIsTypeControl(Message)) {
    Method = CSMGetMethodStr(Message);
    r = 1;
    if(strcmp(Method,"trace_on") == 0){
      User = CSMGetFromAidStr(Message);
      CDebugFlagWrite(AgentID,User);
    }
    if(strcmp(Method,"trace_off") == 0){
      CDebugFlagWrite(AgentID,NULL);
    }
  }
  
  debug_write(AgentID,Message);
  return r;  
}
