
AgentInfo agentInfo;
WorldInfo worldInfo[STACK_SIZE];
int worldID;

char *LOGICAL_AGENT_NAME = "meeting1";
char *PHYSICAL_AGENT_ID = "(null)";
char *PATH = NULL;
char *SUBSTANCE_NAME = "meeting1.pl";
int lock_swt = 1;
int
  main(int argc, char *argv)
{
  InitializeAgentProcess(argc, argv);
  AgentProcessMainLoop();
  TerminateAgentProcess();
  exit(0);
}

int InitializeAgentProcess(int argc, char *argv[])
{
  int fd;
  char *agent_name;

  if (argc != 2){
    fprintf(stderr, "usage : %s port-number\n", argv[0]);
    exit(1);
  }
    
  agent_name = rindex (argv[0], '/');
  if (agent_name == NULL)  agent_name = argv[0];
  else                     agent_name++;
    
  if (init_comm(atoi(argv[1]), 0) < 0) exit (1);
  init_environment(argc, argv);
  if ((fd = init_SICStus_PIPE_substance(PATH, LOGICAL_AGENT_NAME, SUBSTANCE_NAME)) < 0){
    fprintf(stderr, "cannot connect to substance.\n");
    exit(1);
  }
/*  signal(SIGQUIT, agentCatchupSigQuit);*/
  AIInit(LOGICAL_AGENT_NAME, PHYSICAL_AGENT_ID, fd);

}

int TerminateAgentProcess(void){
  close_environment();
  exit_application();
  close_simple_agent();
}

int AgentProcessMainLoop()
{
  SMessage smg;
  int      event_type;
  int      event_data;

  CQNew(3);

  WIPush(NORMAL, QUERY_WAIT, (char *)NULL);

  while(agentInfo.activity == ON){
    if((smg = CQDequeue(MSGQ, CONTROL, NULL, NULL, NULL)) != NULL) {
      appHandleDebugFlag(smg);
      CSMDelete(smg);
    }
    if(SelectMessageAndProcedure() == FAIL){
      event_type = select_event(&event_data);
      switch(event_type){
      case EVENT_EXIT:
	agentInfo.activity = OFF;
	break;
      case EVENT_MESSAGE_SEND_READY:
	flush_message();
	break;
      case EVENT_MESSAGE_RECEIVE_READY:
	while(receive_message(&smg) == 0)
	  CQEnqueue(MSGQ, smg);
	break;
      case EVENT_IO_READY:
	if (event_data == agentInfo.subFd){
	  while(ReceiveFromSubstance(&smg) == 0)
	    CQEnqueue(SIQ, smg);
	}
	else{
	  fprintf(stderr, "receive data from unkown I/O.\n");
	}
	break;
      }
    }
  }
  return 0;
}
/* end of main.c */
char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_SICStus_PIPE_substance(call);
  sprintf(procID, "%d", callID);
  return procID;
}

int
  AICommonParInit()
{
  char buffer[BUFSIZE];
  agentInfo.CPAR.MyName = CCommonToStruct("\"meeting1\"");
  agentInfo.CPAR.date = NULL;
  agentInfo.CPAR.others = NULL;
  return TRUE;
}

