# Makefile.inc
# $Id: Makefile-cmd.inc,v 1.6 1994/12/09 10:39:21 k3sato Exp wazumi $

AR=/bin/ar
RANLIB=/bin/ranlib
CC = gcc

# -pg # -DDEBUG1
CFLAGS = -Wall -g -I${TOPDIR}/include ${CFLAGS_ADD}

all: ${TARGET}

${TARGET}: ${OBJS} ${LIBS} ${LOCAL_LIBS}
	rm -f ${TARGET}
	${CC} ${CFLAGS} -o ${TARGET} ${OBJS} ${LOCAL_LIBS} ${LIBS}

clean:
	rm -f ${TARGET} ${OBJS} core 

dep: ${SRCS}
	$(CPP) ${CFLAGS} -M ${SRCS} > .depend

# libraries
${TOPDIR}/../lib/libcap_common.a:
	rm -f libcap_common.a
	@(cd ${TOPDIR}/cap && ${MAKE} all)
libcap_common.a: ${TOPDIR}/../lib/libcap_common.a
	ln -s ${TOPDIR}/../lib/libcap_common.a .

${TOPDIR}/env/adm/libenv_adm.a:
	rm -f libenv_adm.a
	@(cd ${TOPDIR}/env/adm && ${MAKE} all)
libenv_adm.a: ${TOPDIR}/env/adm/libenv_adm.a
	ln -s ${TOPDIR}/env/adm/libenv_adm.a .

${TOPDIR}/env/dir/libenv_dir.a:
	rm -f libenv_dir.a
	@(cd ${TOPDIR}/env/dir && ${MAKE} all)
libenv_dir.a: ${TOPDIR}/env/dir/libenv_dir.a
	ln -s ${TOPDIR}/env/dir/libenv_dir.a .

${TOPDIR}/comm/libcomm.a:
	rm -f libcomm.a
	@(cd ${TOPDIR}/comm && ${MAKE} all)
libcomm.a: ${TOPDIR}/comm/libcomm.a
	ln -s ${TOPDIR}/comm/libcomm.a .

${TOPDIR}/heliosd/libheliosd.a:
	rm -f libheliosd.a
	@(cd ${TOPDIR}/heliosd && ${MAKE} all)
libheliosd.a: ${TOPDIR}/heliosd/libheliosd.a
	ln -s ${TOPDIR}/heliosd/libheliosd.a .

#
# include a dependency file if one exists
#
# ifeq (.depend,$(wildcard .depend))
# include .depend
# endif
