/* tokens.h
 *
 */

#include "define.h"

#ifndef __tokens__
#define __tokens__

#define STRING    260  /* [a-zA-z_][a-zA-z0-9_]* */
#define QSTRING   261  /* "*" */
#define NUMBER    262  /* [0-9][0-9] */
#define VARIABLE  263  /* #[0-9]+ */
#define PARAMETER 264  /* $[a-zA-z_][a-zA-z0-9_]* */

#define AGENT_TYPE           270  /* &agent_type */
#define AGENT_NAME           271  /* &agent_name */
#define PARA_DEF             272  /* &parameter */
#define INSIDE               273  /* &inside */
#define SUBSTANCE_TYPE       274  /* &substance_type */
#define CONNECT              275  /* &connect */
#define LOCK                 276  /* &lock */
#define TRANSACTION          277  /* &transactin */
#define IMPORT_METHOD        278  /* &import_method */
#define EXPORT_METHOD        279  /* &export_method */
#define SUBSTANCE_QUERY      280  /* &substance_query */
#define SUBSTANCE_CALL       281  /* &substance_call */
#define NEGOTIATION_STRATEGY 282  /* &negotiation_strategy */
#define CAPSULE_PROCEDURE    283  /* &capsule_procedure */
#define SELF_MODEL           284  /* &self_model */
#define CONV_DEF             285  /* &conv */
#define ENVIRONMENT          286  /* &environment */

/* for inside */
#define INSIDE_SUB           290  /* &sub */
#define LIBRARY              291  /* &lib */

/* for export method, substance query */
#define CALL_NEGO            300  /* &negotiation */
#define CALL_PROC            301  /* &procedure */
#define METHOD_SEP           302  /* => */
#define SIG_SEP              303  /* -> */

/* for negotiation, procedure */
#define STATE_DEF            310  /* &state */
#define VAR_DEF              311  /* &var */
#define FROM                 312  /* &from */
#define EXTERNAL             313  /* &external */
#define EXTERNAL_ASK         314  /* &external_ask */
#define EXTERNAL_REPLY       315  /* &external_reply */
#define SUBSTANCE            316  /* &substance */
#define CAPSULE              317  /* &capsule */
#define NEXT_ST              318  /* &next */
#define RETURN               319  /* &return */
#define ASSIGN               320  /* := */
#define EQL                  321  /* == */
#define GREATER              322  /* > */
#define GREATEREQ            323  /* => */
#define LESS                 324  /* < */
#define LESSEQ               325  /* <= */
#define NEGO_RESULT          326  /* &negotiation_result */
#define PROC_RESULT          327  /* &procedure_result */
#define EXTERNAL_ERROR       328  /* &external_error */
#define NOT_EQ               329  /* != */
/* for convert */
#define CONV_SEP             330  /* <=> */
/* for self model */

#define COMMENT              340  /* comment */

/* for environment */
#define USER                 350  /* &user */

extern char clcword[];
extern word keyword_list[];

#endif __tokens__
/* end of top_token.h */
