#include <SMessage.h>

typedef struct {
  int   event_type; /* IMPORT/0, EXPORT/1, CALL/2, QUERY/3 */
  int   proc_type;  /* SUB_CALL/0, EX_ASK/1, NEGO/2, PROC/3 */
  char  *outer_method;
  char  *inner_method;
  int   world;
  char *world_name;
  int   (*method_proc)(SMessage smg);
  int   (*send_proc)(char *data, SMessage smg);
} MethodData;

typedef struct {
  int   np_type; /* PROC/2, NEGO/3 */
  int   world;
  int   state;
  int   (*para_init)(void);
  int   (*para_free)(void);
} nego_proc_data;

typedef struct {
  int   np_type; /* PROC/2 , NEGO/3 */
  int   world;
  int   state;
  int   qtype;   /* ASK/0 , REPLY/2 */
  int   mtype;   /* MsgQ/0 , SIQ/1, NPQ/2 */
  char  *method;
  int  (*method_proc)(SMessage smg);
} nego_proc_proc_data;

#define IMPORT     0
#define EXPORT     1
#define SUB_CALL   2
#define SUB_QUERY  3

#define PROC 0
#define NEGO 1
