/* heliosd.h;
 *	header for Helios Daemon;
 *		created by k3sato on May 18th in 1994.
 *
 *	modification history:	
 *	(1) remove machName from structure of AgentInfo
 *		on July 25th in '94.
 *	(2) add HdMsg_UserAgentId in HeliosdMsgType
 *	    and add a member nextUserId in structure HeliosdCtlInfo
 *		on October 3rd in '94
 *	(3) add HdMsg_ResetAgent in HeliosdMsgType
 *		on October 7th in '94
 *	(4) add the structure _AgentInfo_a
 *		on November 10th in '94.
 *	(5) add AS_WaitAck in AgentStatusType
 *		on November 15th in '94.
 *	(6) add twho structure definitions; FuncDirInfo, MethodDirInfo
 *	    and add two members -- funcDir, methodDir in the structure AgentInfo,
 *		on November 17th in '94.
 *	(7) add HdMsg_AskForCreateAgent in HeliosdMsgType,
 *		on December 7th in '94.
 *	(8) add one enum data type; HdAcceptMsgStatusType,
 *	    and add one struct definition; 
 *		on December 8th in '94.
 *	(9) modified MethodDirInfo so as to handle Import Method, Export Method
 *	    and add struct _MethodNameInfo
 *		on February 7th, '95.
 *	(10) modified type of methodDir in AgentInfo to char*
 *	    and modified structure _FuncDirInfo to handle agent name for function directory
 *		on February 21st, '95.
 *
 * $Id: heliosd.h,v 2.4 1995/03/02 09:27:05 k3sato Exp $
 */

#ifndef _heliosd_h_

#define _heliosd_h_

#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

/*
 *	define constants
 */
/*	define names of number constant.
 */
#define ERROR_FLAG	-1		/* error return code of system functions */

/*
 * HELIOSD_SLEEP_TIME :
 *	sleep time for creating subprocess (hdDAMessage.c)
 */
#define HELIOSD_SLEEP_MAX_TIME	50
#define HELIOSD_SLEEP_SPAN	1

#define HdMaxNumOfRetry		2

#define HeliosdFilePathLen_Lim	256
#define HdFileBufferLen_Lim	1024
#define	HostNameLen_Lim		32
#define AgentIDLen_Lim		512
#define AgentNameLen_Lim	128
#define AgentPathLen_Lim	256	/* limit of the full path to agent process */
#define MsgBufferLen_Lim	1024
#define SocketBufferLen_Lim	5120
#define HdSocketBackLog_Lim	5
#define HdStringLength_Lim	0x0000FFFF
#define HdIntString_Lim		32

#ifdef _Heliosd_Static_Port_Num

#define HeliosdPortNum		3000
#define HdAgentPortNumBase	HeliosdPortNum + 1
#define HeliosdPortNum_Lim	5999

#endif

/*	define names of string constant.
 */
#define HeliosdLockFileDir	"/tmp"
#define HeliosdLockFileName	".heliosdLOCK"

#define HeliosHiaFileName	"helios.hia"
#define HeliosInitFileName	"helios.init"
#define HeliosDalFileName	"helios.dal"

/*
 *  delimiter of a word
 */
#define HdChar_NULL		'\0'
#define HdChar_CR		'\n'
#define HdChar_LF		'\012'
#define HdChar_Space		' '
#define HdChar_Tab		'\t'
#define HdChar_Colon		':'
#define HdChar_Semicolon	';'
#define HdChar_Ampersand	'&'
#define HdChar_LeftParen	'('
#define HdChar_RightParen	')'
#define HdChar_Comma		','
#define HdChar_Minus		'-'
#define HdChar_Period		'.'
#define HdChar_EscCode		'\\'
#define HdChar_EqualCode	'='

#define HdChar_DoubleQuot	'\"'
#define HdChar_SingleQuot	'\''
#define HdChar_SlantCode	'/'

#define HdChar_Underscore	'_'
#define HdChar_LeftBrace	'{'
#define HdChar_RightBrace	'}'
#define HdChar_LeftBracket	'['
#define HdChar_RightBracket	']'

/*
 *	define enumeration types
 */
/*	Boolean for Helios Daemon
 */
typedef enum {
    HdFalse,
    HdTrue,
} HdBoolean;

/*	Message type for Helios Daemon
 */
typedef enum {
    HdMsg_GetAgent = 1,		/* messages from Agent to Daemon */
    HdMsg_GetAgentInfo,
    HdMsg_GetAllAgentInfo,
    HdMsg_DeleteAgent,
    HdMsg_SetupUserInfo,	/* $B5/F0$7$?%f!<%6!&%$%s%?%U%'!<%9$N>pJs$N@_Dj(B */
    HdMsg_GetUserInfo,		/* $B5/F0$5$l$F$$$k%f!<%6!&%$%s%?%U%'!<%9$N>pJs$N3MF@(B */
    HdMsg_StartAppGui,		/* $B%"%W%j%1!<%7%g%sBP1~(B GUI $B$N5/F0MW5a(B */
    HdMsg_ResetAgent,		/* $B3F(B agent process $B$KBP$9$k(B reset $B%a%C%;!<%8AwIUMW5a(B */

    HdMsg_ParametricAgent = 100,/* parametric agent $B4X78(B */
    HdMsg_GetParaAgent,		/* parametric agent $B$N@8@.!"5Z$S(B socket $B>pJs$N3MF@(B */
    HdMsg_RegisterParaAgent,	/* parametric agent $B$NEPO?MW5a(B */

    HdMsg_AskForNextInfo = 200,	/* $B<!$N>pJs$NAwIU$NMW5a(B*/


    HdMsg_SocketInfo = 500,	/* reply messages from Daemon to Agent */
    HdMsg_AgentInfo,		/* agent information */
    HdMsg_AgentInfoEnd,		/* end of agent information */
    HdMsg_FuncDirInfo,		/* function directory information */
    HdMsg_MethodDirInfo,	/* method directory information */

    HdMsg_UserAgentId,		/* agentId for user */

    HdMsg_Success = 800,	/* Success message for command from agent */


    /* error reply messages from Daemon to Agent */

    HdMsg_AskAgentInfo = 1000,	/* messages from Daemon to other Daemon */
    HdMsg_AskForCreateAgent,

    HdMsg_AgentInfo2D = 1500,	/* reply messages from Daemon to other Daemon */
    HdMsg_NotExistAgent,

    HdMsg_ErrorDetected = 1900,	/* error reply messages common to both A2D and D2D. */

} HeliosdMsgType;

/*	Agent Type
 */
typedef enum {
    HdAT_NotDefined,
    HdAT_Single,	/* Single Agent */
    HdAT_Complex,	/* Complex Agent */
    HdAT_Parametric,	/* Parametric Agent */
    HdAT_ParaInstance,	/* Instance of Parametric Agent */
} HdAgentType;

/*	Method Type
 */
typedef enum {
    HdMT_NotDefined,
    HdMT_Import,
    HdMT_Export,
} HdMethodType;

/*	Status type for Agent process
 */
typedef enum {
    AS_NotExist,	/* not exist as any files of agent process */
    AS_NotActive,	/* exist as some files but not execute the process */
    AS_Active,		/* on executing the process of agent */
    AS_Sleep,		/* not executed the process, but fiexed portNum */
    AS_WaitAck,		/* running but waiting for acknoledge message */
} AgentStatusType;

/*	Function type for HdMsgHandleArgs
 */
typedef enum {
    HdFT_ReceiveSockInfo,
} HdFuncType;

/*	Status type for Accepted Messages
 */
typedef enum {
    HdAMS_NoWait,
    HdAMS_SendAskAgentInfoWait,	/* wait for sending AskAgentInfo to other daemon */
    HdAMS_SendAskForCreatingWait,/* wait for sending AskForCreating to other daemon */
    HdAMS_SendSockInfoWait,	/* wait for sending SocketInfo to agent */
    HdAMS_ReceiveAgentInfoWait,	/* wait for receiving agent info from other daemon */
    HdAMS_ReceiveSockWait,	/* wait for receiving socket info from other daemon */
} HdAcceptMsgStatusType;

/*
 *	define struct types
 */
/*	structure for function directory information
 */
typedef struct _FuncDirInfo	*HFuncDirInfo;

typedef struct _FuncDirInfo {
    char		*funcName;
    char		*agentNames;
    HFuncDirInfo	next;
} FuncDirInfo;

/*	structure for method directory information
 */
typedef struct _MethodDirInfo	*HMethodDirInfo;

typedef struct _MethodNameInfo	*HMethodNameInfo;

typedef struct _MethodNameInfo {
    char		*methodName;
    HMethodNameInfo	next;
} MethodNameInfo;

typedef struct _MethodDirInfo {
    HdMethodType	type;
    HMethodNameInfo	methodName;
    HMethodDirInfo	next;
} MethodDirInfo;

/*	structure for machine information
 */
typedef struct _MachInfo	*HMachInfo;

typedef struct _MachInfo {
    char	*hostName;
    struct sockaddr_in	sockAddress;	/* address from name server */
    int		addressSize;
    int		sock;
    HMachInfo	next;
} MachInfo;

/*	structure for socket information
 */
typedef struct _SocketInfo	*HSocketInfo;

typedef struct _SocketInfo {
    char	*hostName;
    short	sin_family;
    u_short	sin_port;
} SocketInfo;

/*	structure for agent information
 */
typedef struct _AgentInfo	*HAgentInfo;

typedef struct _AgentInfo {
    HdAgentType		type;		/* agent type : Single, Complex, Parametric */
    char		*agentId;	/* agent ID */
    char		*agentPath;	/* full path of agent */
    char		*agentName;	/* agent name */
    char		*procArgs;	/* arguments to pass through agent process */
    HFuncDirInfo	funcDir;	/* function directory information */
    char*		methodDir;	/* HMethodDirInfo: method directory information */
    SocketInfo		sockInfo;	/* socket information */
    int			pid;		/* process ID */
    AgentStatusType	status;		/* agent status; active or not */
    int			groupNum;	/* number to group agents for monitor */
    char		*comment;	/* comment for a agent */
    HAgentInfo		parent;		/* parent agent info */
    HAgentInfo		child;		/* child agent info */
    HAgentInfo		next;		/* parent agent info */
} AgentInfo;

/*	structure to get AgentInfo from Daemon
 */
typedef struct _AgentInfo_a	*HAgentInfo_a;

typedef struct _AgentInfo_a {
    int			address;
    HAgentInfo		agentInfo;
    HAgentInfo_a	next;
} AgentInfo_a;

/*  structure for arguments to handle waiting msg
 */
typedef struct _HdMsgHandleArgs	*HHdMsgHandleArgs;

typedef struct _HdMsgHandleArgs {
    HdFuncType			type;
    union {
	char			*agentId;
	HAgentInfo		agentInfo;
    } arg1;
    union {
	HAgentInfo		agentInfo;
    } arg2;
} HdMsgHandleArgs;

/*	structure for accept Message handled in heliosd.
 */
typedef struct _HdAcceptMsgInfo	*HHdAcceptMsgInfo;

typedef struct _HdAcceptMsgInfo {
    HeliosdMsgType		type;
    char			*agentId;
    int				acceptFd;
    HMachInfo			machInfo;	/* socket info of connected daemon */
    HdAcceptMsgStatusType	status;
    HdMsgHandleArgs		args;
    HHdAcceptMsgInfo		next;
} HdAcceptMsgInfo;

/*	structure for heliosd control information
 */
typedef struct _HeliosdCtlInfo	*HHeliosdCtlInfo;

typedef struct _HeliosdCtlInfo {
    int			s_listen;		/* socket descriptor */
    int			s;			/* descriptor for the accepted socket */
    HeliosdMsgType	msgType;		/* accept message type */
    HMachInfo		machInfo;		/* machine information */
    HAgentInfo		allAgents;		/* all agent info of self */
    HAgentInfo		appGuiInfo;		/* all application gui info fo self */
    HAgentInfo		otherDaemonsInfo;	/* agent info of other's daemons */
    HAgentInfo		userInfo;		/* user info handled in own machine */
    HdBoolean		waitFlag;		/* flag to wait to retry */
    HHdAcceptMsgInfo	acceptMsg;		/* accept message waiting for handling */
    int			nextUserId;		/* next agent Id for user */
    u_short		nextPortNum;		/* next port number for agent */
    char		*fullPath;		/* full path directory of executed heliosd */
} HeliosdCtlInfo;

#endif /* _heliosd_h_ */
