/* define.h
 *        header file of definition of capl compiler module.
 */

#ifndef __define__
#define __define__

struct _word {
  char *word;
  int  token;
};
typedef struct _word word;

#define STACK_SIZE 40
#define CALL_SUB   0
/*--------------------
#define CALL_PROC  1     token $B$GMxMQ(B
#define CALL_NEGO  2     token $B$GMxMQ(B
--------------------*/
#define EX_ASK     3     

#define NO_TYPE    -1
#define INT_TYPE    0
#define STR_TYPE    1
#define BOOL_TYPE   2
#define LIST_TYPE   3
#define VEC_TYPE    4
#define TUPLE_TYPE  5

#define BUFSIZE   1024
#define ARG_MAX   10
#define STATE_MAX 100
#define TABLE_MAX 100
#define LIST_MAX  50
#define TO_MAX    10
#define PARA_MAX  20
#define TYPE_MAX  20
#define LIB_MAX   10
#define AP_MAX    50
#define PROC_MAX  50
#define NEGO_MAX  50

#define TRUE  1
#define FAIL  0
#define FALSE 0

#define ON     1
#define OFF    0
#define ONOFF -1

#define MSGQ 0
#define SIQ  1
#define NPQ  2

#define ASK   0
#define REPLY 1

#define SUB_CALL 0
#define NEGO     1
#define PROC     2
#define EX_ASK   3


typedef struct _state_method {
  int state; /* char state[STATE_MAX] $B$N%$%s%G%C%/%9(B */
  int queue; /* MsgQ, SIQ, NPQ */
  int mtype; /* ASK, REPLY */
} state_method;

#endif __define__
/* end of define.h */
