#ifndef COMMONTYPE


/* Common Data Handling Library */

/* Data Structure */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define Cstruct 0
#define Cinteger 1
#define Cstring 2
#define Cbool 3
#define Cnone 0
#define Cvector 1
#define Clist 2
#define Ctupple 3
#define Cset 4

struct ComData ComData;

typedef struct ComData *CDATA;

union CElem {
  long integer;
  int bool;
  char *string;
  CDATA element;
};

struct ComData {
  int base;     /* base = 0: structure (Use type) 1:int  2:String 3:bool */ 
  int type;     /* (if base = 0) type 0:none 1:vector 2:list 3:tupple 4:set */
  union CElem next;
  union CElem data;
} ComData;


/* Handling Function */

CDATA CNew(int base,int type);
CDATA  CDelete(CDATA val);
CDATA CDuplicate(CDATA val);
CDATA CPutElement(CDATA vec,int position,CDATA element);
CDATA CGetElement(CDATA vec,int position);
int CLength(CDATA vec);


/* for BASIC */

CDATA CBPutInt(CDATA basic,long integer);
long CBGetInt(CDATA basic);

CDATA CBPutBool(CDATA basic,int bool);
int CBGetBool(CDATA basic);

CDATA CBPutString(CDATA basic,char* string);
char *CBGetString(CDATA basic);

/* for Vector */

CDATA CVPutElement(CDATA vec,int position,CDATA data);
CDATA CVGetElement(CDATA vec,int position);
int CVLength(CDATA vec);

/* for List */

CDATA CLCar(CDATA list);
CDATA CLCdr(CDATA list);
CDATA CLPutElement(CDATA list,int position,CDATA data);
CDATA CLGetElement(CDATA list,int position);
int CLLength(CDATA list);

/* for tupple */

CDATA CTPutElement(CDATA tup,char *tag,CDATA data);
CDATA CTGetElement(CDATA tup,char *tag);
char *CTGetTag(CDATA tup,int position);
int CTLength(CDATA tup);

/* for set */
CDATA CSPutData(CDATA set,int position,CDATA data);
CDATA CSGetData(CDATA set,int position);
int CSLength(CDATA set);

/* for Functor */

CDATA CFPutElement(CDATA fun,int position,CDATA data);
CDATA CFGetElement(CDATA fun,int position);
int CFLength(CDATA vec);

#define COMMONTYPE
#endif
