/* CRecord.h
 *    header file for handling a record in capsule.
 *
 */

#include <helios/CaplDef.h>
#include <CRNode.h>

#ifndef __CRecord__
#define __CRecord__

typedef struct _CRecordM {
  CRNode head;
  CRNode tail;
} CRecordM;

typedef CRecordM *CRecord;

extern CRecord record;

extern CRecord CRecordNew(void);
extern int CRecordInit();
extern int
  CREnqueue(SMessage smg, int src, int dist,
	    char *procID, int worldID, int flag);

extern 
  CRNode CRSelect(char *mid, char *method, int src, int dist,
		  char *procID, int worldID, int flag);

extern int CRSetSubstanceReqFlagOn(char *methodID);

#endif __CRecord__
/* end of CaplRecord.h */
