/* CRNode.h
 *    header file for handling nodes of a record in capsule.
 *
 */
#include <helios/SMessage.h>
#include <helios/CaplDef.h>

#ifndef __CRNode__
#define __CRNode__


typedef struct _CRNodeM {
  int src;
  int dist;
  SMessage smg;
  char     procID[BUFSIZE];
  int      worldID;
  int reqFlag;
  struct _CRNodeM *front;
  struct _CRNodeM *rear;
} CRNodeM;

typedef CRNodeM *CRNode;

extern CRNode
  CRNNew(SMessage smg, int src, int dist,
	    char *procID, int worldID, int flag);

extern int CRNFree(CRNode node);
extern int CRNDelete(CRNode node);

extern CRNode
  CRNSelect(CRNode node, char *mid, char *method,
	    int src, int dist, char *procID,
	    int worldID, int flag);

#endif __CRNode__

/* end of CRNode.h */

