
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <SMessage.h>
#include <C_sub_cap.h>
#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <make_message.h>
#include <method_proc.h>
#include <info_table.h>
#include <CQueue.h>
#include <CRecord.h>
typedef enum {
  NO_STATE = -1,
  QUERY_WAIT,
  REPLY_WAIT,
  RUNNING,
  RUNNING2,
  N_RUNNING,
  P_RUNNING,
} State;

typedef enum {
  NO_WORLD = -1,
  NORMAL,
} World;

struct {
  char *world_name; World world; State init;
} world_list[] = {
  { "NORMAL", NORMAL, NO_STATE },
  { NULL, NO_WORLD, NO_STATE }
};
typedef union {
} LocalParM;
typedef LocalParM *LocalPar;
typedef struct {
  int  wtype;  /* NORMAL/0, PROC/1, NEGO/2 */
  World world;
  World preWorld;
  int stateID;
  State state[STACK_SIZE];
  char tid[BUFSIZE];
  LocalPar lPar;
  SMessage start_smg;
} WorldInfoM;
typedef WorldInfoM *WorldInfo;

#define WI         (worldInfo[worldID])
#define WIstate    (worldInfo[worldID]->state[worldInfo[worldID]->stateID])
#define WIstateID  (worldInfo[worldID]->stateID)
#define WItid      (worldInfo[worldID]->tid)
#define WIworld    (worldInfo[worldID]->world)
#define WIpreWorld (worldInfo[worldID]->preWorld)
#define WIlPar     (worldInfo[worldID]->lPar)

int       worldID = -1;
WorldInfo worldInfo[WORLD_SIZE];

typedef struct {
  CDATA me;
  CDATA para1;
  CDATA para2;
} CommonParM;
typedef CommonParM *CommonPar;
typedef struct {
  int  subFd;
  int  activity;
  char agentName[BUFSIZE];
  char agentID[BUFSIZE];
  CommonPar cPar;
} AgentInfo;
AgentInfo agentInfo;
MethodData MethodList[]={
  { IMPORT, -1, "begin_transaction", NULL, NORMAL, "NORMAL", ASKBeginTransaction, NULL },
  { IMPORT, -1, "commit",            NULL, NORMAL, "NORMAL", ASKCommit,           NULL },
  { IMPORT, -1, "begin_negotiation", NULL, NORMAL, "NORMAL", ASKBeginNegotiation, NULL },
  { IMPORT, SUB_CALL, "open", "meeting",
    NORMAL, "NORMAL", ASKtoCALL, NULL },
  { EXPORT, RESULT, "checkroom", "room",
    NORMAL, "NORMAL", RESULTtoREPLY, ASK_room },
  { SUB_CALL, REPLY, "meeting", "meeting",
    NORMAL, "NORMAL", RESULTtoREPLY, NULL },
  { SUB_QUERY, EX_ASK, "room", "checkroom",
    NORMAL, "NORMAL", QUERYtoASK, NULL },
  { -1, -1, NULL, NULL, -1, NULL, NULL, NULL },
};
nego_proc_data nego_proc_list[]={
  { -1, -1, -1, -1, -1, NULL, NULL },
};

nego_proc_proc_data nego_proc_proc_list[]={
  { -1, -1, -1, -1, -1, NULL, NULL },
};

int ASK_room(char *data, SMessage smg)
{  
  SMessage ask_smg;
  ask_smg = MakeAskMessage("test", NULL, WItid, "room", data);
  send_message(ask_smg);
  CREnqueue(smg, SUBSTANCE, EXTERNAL, strdup(CSMGetMidStr(smg)),
            worldID, Off);
  return TRUE;
}

int
  AICommonParInit()
{
agentInfo.cPar->me = CCommonToStruct(""test01"");
agentInfo.cPar->para1 = CCommonToStruct("123");
agentInfo.cPar->para2 = NULL;
  return TRUE;
}


int
  AIInit(char *agentName, char *agentID, int fd)
{
  agentInfo.subFd = fd;
  agentInfo.activity = ON;
  if(agentName != (char *)NULL)
    strcpy(agentInfo.agentName, agentName);
  if(agentID != (char *)NULL)
    strcpy(agentInfo.agentID, agentID);
  AICommonParInit();
  return TRUE;
}

void
  appHandleDebugFlag(SMessage smg)
{
  char		*method;

  if ((method = CSMGetMethodStr(smg)) != NULL) {
    if (!strcmp(method, "trace_on")) {
      CDebugFlagWrite(agentInfo.agentID, CSMGetFromAidStr(smg));
    } else if (!strcmp(method, "trace_off")) {
      CDebugFlagWrite(agentInfo.agentID, NULL);
    }
  }
}

State SelectWorldInit(World world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}

static char *new_tid()
{
  char buffer[BUFSIZE];
  static int no = -1;

  no = (no+1)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ;
  sprintf(buffer, "%s_%s", agent_id, no);
  return strdup(buffer);
}

int QUERYtoASK(SMessage smg)
{
  CDATA tmps;
  char *data;
  char *inner_method;
  int i;
  int (*func)(char*, SMessage);

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPMethodConvCommonEnv(inner_method tmps);
    CDelete(tmps);
    func = SelectAskProcedure(EXPORT, inner_method);
    if(func != NULL) func(data, smg);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from substance to common \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ASKtoQUERY */
int ASKtoCALL(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  char call_id[BUFSIZE];
  char errorSmg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    call_id = CallSubstanceProcedure(data, call_id);
    CREnqueue(smg, EXTERNAL, SUBSTANCE, call_id, worldID, Off);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from common to substance \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
    errorSmg = MakeErrorMessage(smg);
    send_message(errorSmg);
  }
  return TRUE;
}

/* ReplyToResult */
int REPLYtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(SUBSTANCE, EXTERNAL,
		    CSMGetMisStr(smg), worldID, ON);
    PutResultToSubstance(data, node->query_id);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from common to substance.\n");
    fprintf(stderr, "method = LY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, "illegal result request from substance");
      return event;
    }
    *smg = NULL;
    return event;
  case RESULT:
    SelectInnerMethod(CALL, sub_proc, method);
    CSMTypeReply(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case QUERY:
    SelectInnerMethod(QUERY, sub_proc, method);
    CSMTypeAsk(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case NO_DATA:
    *smg = NULL;
    return event;
  default:
    fprintf(stderr, "capsule gets illegal data from substance\n");
    return NO_DATA;
  }
}
\n", inner_method);
    fprintf(stderr, "data   = checkroom\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ResultToReply */
int RESULTtoREPLY(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;
  SMessage reply_smg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPMethodConvCommonEnv(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(ECTERNAL, SUBSTANCE,
		    CSMGetMisStr(smg), worldID, ON);
    reply_smg = MakeReplyMessage(node->smg, data);
    send_message(reply_smg);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from substance to common.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
    reply_smg = MakeErrorMessage(node->smg);
    send_message(reply_smg);
  }
  return TRUE;
}

/* QUERYtoNEGO */
int QUERYtoNEGO(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  World world;
  char world_name[BUFSIZE];
  State init;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    CREnqueue(smg, SUBSTANCE, NEGOTIATION, 
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDulicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(queue[SIQ], new_smg);
    world = SelectNegotiationStrategy(QUERY, CSMGetMethodStr(smg), world_name);
    init = SelectWorldInit(world);
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  else{
    fprintf(stderr, "illegal data of method.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* QUERYtoPROC */
int QUERYtoPROC(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  World world;
  State init;
  char world_name[BUFSIZE];

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDulicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(queue[SIQ], new_smg);
    world = SelectCapsuleProcedure(QUERY, CSMGetMethodStr(smg), world_name);
    CREnqueue(smg, SUBSTANCE, PROCEDURE, world_name, worldID, OFF);
    init = SelectWorldInit(world);
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  else{
    fprintf(stderr, "illegal data of method.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ASKtoNEGO */
int ASKtoNEGO(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  Wolrd world;
  State init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicate(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(queue[MsgQ], new_smg);
  world = SelectNegotiationStrategy(IMPORT, CSMGetMethodStr(smg), world_name);
  init = SelectWorldInit(world);
  CREnqueue(smg, EXTERNAL, NEGOTIATION, world_name, worldID, ON);
  WIPush(world, init, tid);
  NP_ParaInit(world)();
  return TRUE;
}

/* ASKtoPROC */
int ASKtoPROC(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  Wolrd world;
  State init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicate(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(queue[MsgQ], new_smg);
  world = SelectCapsuleProcedure(IMPORT, CSMGetMethodStr(smg), world_name);
  init = SelectWorldInit(world);
  CREnqueue(smg, EXTERNAL, PROCEDURE, world_name, worldID, ON);
  WIPush(world, init, tid);
  NP_ParaInit(world)();
  return TRUE;
}

/* NEGO_PROC_RESULTtoREPLY */
int NEGO_PROC_RESULTtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *data;
  CRNode node;

  tmps = CCommonToStruct(CSMGetDataStr(smg));
  data = CAPSubstanceConvCommonLocal(CSMGetMethodStr(smg), tmps);
  CDelete(tmps);
  node = CRSelect(SUBSTANCE, NEGO_PROC,
		  CSMGetMidStr(smg), worldID, ON);
  PutResultToSubstance(data, node->query_id);
  CRNDelete(node);
  free(data);
  return TRUE;
}

/* NEGO_PROC_RESULTtoREPLY */
int NEGO_PROC_RESULTtoREPLY(SMessage smg)
{
  CRNode node;
  SMessage reply_smg;

  CDelete(tmps);
  node = CRSelect(EXTERNAL, NEGO_PROC,
		  CSMGetMidStr(smg), worldID, ON);
  reply_smg = MakeReplyMessage(node->smg, CSMGetDataStr(data));
  send_message(reply_smg);
  free(data);
  CRNDelete(node);
  return TRUE;
}

char *SelectInnerMethod(int mtype, char *method, char *inner_method)
{
  int i;

  for(i = 0; MethodDataList[i].mtype != -1; i++){
    if(mtype == MethodDataList[i].mtype &&
       strcmp(method, MethodDataList[i].proc) == 0) break;
  }
  if(MethodDataList[i].mtype != -1){
    strcpy(inner_method, MethodDataList[i].inner_method);
    return inner_method;
  }
  else{
    return NULL;
  }
}

int ASKBeginTransaction(SMessage smg)
{
  char *tid;
  SMessage replySmg;

  tid = new_tid;
  WItid = tid;
  replySmg = MakeReplyMessage("true", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKCommit(SMessage smg)
{
  if(WItid != NULL){
    free(WItid);
    WItid = NULL;
  }
  replySmg = MakeReplyMessage("true", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKBeginNegotiation(SMessage smg)
{
  char *tid;
  World world;

  world = SelectNP_id(CSMGetDataStr(smg));
  if(world != NO_WORLD){
    tid = strdup(CSMGetTidStr(smg));
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  return TRUE;
}

int (*SelectAskProc(int mtype, char *inner_method))(char*, SMessage)
{
  int i;

  for(i = 0; MethodDataList[i].event_type != -1; i++){
    if(MethodDataList[i].event_type == mtype &&
       strcmp(inner_method, MethodDataList[i].inner_method) == 0)
      return MethodDatalist[i].send_proc;
  }
  return NULL;
}

State SelectWorldInit(World world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}

char *CCommonToTOstring(char *org, char *to)
{
  int i;

  for(i = 0; org[i] != NULL; i++){
    if(org == '[' || org == ']' || org == '<' || org == '<' ||
       org == '(' || org == ')' || org == '=' || org == ','){
      to[i] = ' ';
    }
    else{
      to[i] = org[i];
    }
  }
  return to;
}
/* begin_transactin */
char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_C_application(call);
  sprintf(procID, "%d", callID);
  return procID;
}

int
  PutResultToSubstance(char *procID, char *result)
{
  put_result_to_C_application(result);
  return 0;
}

int
  ReceiveFromSubstance(SMessage *smg)
{
  char data[BUFSIZE], id[10];
  char sub_proc[BUFSIZE];
  char method[BUFSIZE];
  int  event;
  int  i;

  switch(event = get_data_from_C_application(sub_proc, data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(id);
    if(WIstate == RUNNING){
      WIPushState(REPLY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, "illegal result request from substance");
      return event;
    }
    *smg = NULL;
    return event;
  case RESULT:
    SelectInnerMethod(CALL, sub_proc, method);
    CSMTypeReply(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case QUERY:
    SelectInnerMethod(QUERY, sub_proc, method);
    CSMTypeAsk(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case NO_DATA:
    *smg = NULL;
    return event;
  default:
    fprintf(stderr, "capsule gets illegal data from substance\n");
    return NO_DATA;
  }
}
