/*
 * file name : agent2_env_.c
 *
 */

#include		<stdio.h>
#include		<helios/envdef.h>
#include		<helios/eInit.h>
#include		<helios/Henv.h>
#include		<helios/HeAgSv.h>
#include		<helios/HeAgSvDef.h>
#include		<helios/HeAgSvFun.h>

static	int	e_init_agent_server(void);
static	int	e_init_global_pool(void);

int
init_environment(int argc, char **argv)
{
  e_init_agent_server();
  e_init_global_pool();

  eInitArg(argc, argv);
  eInitStart();
  eInitSetEnv("testapp", "0.1");
  eInitSetEnv("midtest", "0.1.1");
  eInitMyAid("0.1.1.2");
  eInitEnd();
  return NORMAL;
}


static
int
e_init_agent_server(void)
{
  add_to_agent_directory("0.1", "midtest", "0.1.1");
  add_to_agent_directory("0.1.1", "agent1", "0.1.1.1");
  add_to_agent_directory("0.1.1", "agent2", "0.1.1.2");
  add_to_agent_directory("0.1.1", "agent3", "0.1.1.3");
  add_to_agent_directory("0.1.1", "agent4", "0.1.1.4");

  add_to_function_directory("0.1.1", "Queen", "0.1.1.1");
  add_to_function_directory("0.1.1", "Queen", "0.1.1.2");
  add_to_function_directory("0.1.1", "Solve", "0.1.1.3");

  return NORMAL;
}


static
int
e_init_global_pool(void)
{
  add_to_global_pool("0.1", "C2Type", "v_name2", "67890");
  add_to_global_pool("0.1.1", "C2Type", "v_name2", "67890");
  return NORMAL;
}

/*** END OF FILE ***/
