#include <stdio.h>
#include <string.h>
#include <helios/CommonType.h>
#include <helios/commonConst.h>
#include <helios/commonParse.h>
#include <helios/libcommon.h>
#include <helios/CAppConv.h>

#include <helios/SMessage.h>
#include <helios/event.h>
#include <CQueue.h>
#include <CRecord.h>
#include <CDefine.h>

struct {
  int  subFd;
  int  activity;
  char agent_name[BUFSIZE];
  char agent_id[BUFSIZE];
/*  CommonPar cPar; */
} agent_info;

struct {
  int  wtype;  /* NORMAL/0, PROC/1, NEGO/2 */
  int  world;
  int  state_id;
  int  state[STACK_SIZE];
  char tid[BUFSIZE];
/*  LocalPar lPar; */
  SMessage start_smg;
} world_info;

struct {
  int event_type; /* IMPORT, EXPORT, SUB_CALL, SUB_QUERY */
  int proc_type;  /* SUB_CALL, PROCEDURE, NEGOTIATION, EX_ASK */
  char *inner_method;
  char *outer_method;
  int (*method_proc)(SMessage smg);

  int (*send_proc)(char *data);
} method_list[] = {
  { -1, -1, NULL, NULL, NULL, NULL }
};
  
int AIactivity
char *LOGICAL_AGENT_NAME= "agent1";
char *PHYSICAL_AGENT_ID = "0.20.1";
char *SUB_PATH = "/usr/local/bin";
char *SUBSTANCE_NAME = "agent1";

int LOCK_SWT = ON;

extern int InitializeAgentProcess(int argc, char *argv[]);
extern int AgentProcessMainLoop(void);
extern int TerminateAgentProcess(void);
extern int SelectMessage(SMessage *smg);

extern char *CallSubstanceProcedure(char *data, char call_id[]);

extern agent_info_init(char *name, char *id, int fd);

extern init_SICStus_PIPE_substance(char *path,
				   char *agent_name,
				   char *substance);
extern int exit_SICStus_PIPE_substance(void);


int main(int argc, char *argv[])
{
  InitializeAgentProcess(argc, argv);
  AgentProcessMainLoop();
  TerminateAgentProcess();
  return 0;
}

int InitializeAgentProcess(int argc, char *argv[])
{
  char *agent_name;
  int fd;

  if (argc != 2){
    fprintf(stderr, "usage : %s port-number\n", argv[0]);
    exit(1);
  }
  agent_name = rindex (argv[0], '/');
  if (agent_name == NULL)  agent_name = argv[0];
  else                     agent_name++;
  if (init_comm(atoi(argv[1]), 0) < 0) exit (1);
  init_environment(argc, argv);
  if ((fd = init_SICStus_PIPE_substance(SUB_PATH,
				       LOGICAL_AGENT_NAME,
				       SUBSTANCE_NAME))
      < 0){
    fprintf(stderr, "cannot connect to substance.\n");
    exit(1);
  }
  agent_info_init(LOGICAL_AGENT_NAME, PHYSICAL_AGENT_ID, fd);
  return TRUE;
}

int TerminateAgentProcess(void){
  close_environment();
  exit_SICStus_PIPE_substance();
  return 0;
}

int AgentProcessMainLoop(void)
{
  SMessage smg;
  int      event_type;
  int      event_data;
  int      index;

  queue[MSGQ] = CQNew();
  queue[SIQ]= CQNew();
  queue[NPQ] = CQNew();

  while(agent_info.activity == ON){
    index = SelectMessage(&smg);
    if(smg == NULL){
      event_type = select_event(&event_data);
      switch(event_type){
      case EVENT_EXIT:
	agent_info.activity = OFF;
	break;
      case EVENT_MESSAGE_SEND_READY:
	flush_message();
	break;
      case EVENT_MESSAGE_RECEIVE_READY:
	while(receive_message(&smg) == 0)
	  CQEnqueue(queue[MSGQ], smg);
	break;
      case EVENT_IO_READY:
	if (event_data == agent_info.subFd){
	  while(ReceiveFromSubstance(&smg) == 0)
	    CQEnqueue(queue[SIQ], smg);
	}
	else{
	  fprintf(stderr, "receive data from unkown I/O.\n");
	}
	break;
      }
    }
    else{
      MethodProcedure(index, smg);
    }
  }
  return 0;
}

int SelectMessage(SMessage *smg)
{
  char *ids[TABLE_MAX];
  int i, n;

  for(i = 0; i < TABLE_MAX; i++) ids[i] = NULL;
  if(world_info.wtype == NORMAL){
    if(world_info.state[world_info.state_id] == QUERY_WAIT){
      select_normal_method(IMPORT, ids);
      *smg = CQDequeue(queue[MSGQ], ASK, NULL, NULL, ids);
      n = MSGQ;
    }
    else if(world_info.state[world_info.state_id] == REPLY_WAIT){
      CRMultiSelect(SUBSTANCE, EXTERNAL, NULL, ids);
      *smg = CQDequeue(queue[MSGQ], REPLY, ids, NULL, NULL);
      n = MSGQ;
      if(*smg == NULL && LOCK_SWT == OFF){
	for(i = 0; i < TABLE_MAX; i++){
	  if(ids[i] != NULL) free(ids[i]);
	}
	*smg = CQDequeue(queue[MSGQ], ASK, NULL, NULL, ids);
	n = MSGQ;
      }
    }
    else if(world_info.state[world_info.state_id] == RUNNING){
      select_normal_method(QUERY, ids, TABLE_MAX);
      n = SIQ;
      *smg = CQDequeue(queue[SIQ], ASK, NULL, NULL, ids);
      if(*smg == NULL){
	if(*smg == NULL && LOCK_SWT == OFF){
	  for(i = 0; i < TABLE_MAX; i++){
	    if(ids[i] != NULL) free(ids[i]);
	    ids[i] = NULL;
	  }
	}
	CRMultiSelect(SUBSTANCE, EXTERNAL, NULL, ids);
	*smg = CQDequeue(queue[SIQ], ASK, ids, NULL, NULL);
      }
    }
#if 0
    else if(world_info.state[world_info.state_id] == N_RUNNING){
      CRMultiSelect(-1, NEGOTIATION, NULL, ids);
      *smg = CQDequeue(queue[NPQ], REPLY, ids, NULL, NULL);
      n = NPQ;
    }
    if(world_info.state[world_info.state_id] == P_RUNNING){
      CRMultiSelect(-1, PROCEDURE, NULL, ids);
      *smg = CQDequeue(queue[NPQ], REPLY, ids, NULL, NULL);
      n = NPQ;
    }
#endif
  }
  return TRUE;
}

int PutResultToSubstance(char *data, char *procID)
{
  put_result_to_SICStup_PIPE_substance(*data);
  return 0;
}

int ReceiveFromSubstance(SMessage *smg)
{
  char data[BUFSIZE], id[10];
  char sub_proc[BUFSIZE];
  char method[BUFSIZE];
  int  event;

  switch(event = getdata_SICStus_PIPE_substance(sub_proc, data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(id);
    if(world_info.state[world_info.state_id] == RUNNING){
      world_info_push_state(REPLY_WAIT);
    }
    else if(world_info.state[world_info.state_id] == RUNNING2){
	world_info_change_state(REPLY_WAIT);
    }
    else {
      fprintf(stderr, "illegal result request from substance");
      return event;
    }
    *smg = NULL;
    return event;
  case RESULT:
    SelectInnerMethod(SUB_CALL, sub_proc, method);
    CSMTypeReply(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case QUERY:
    SelectInnerMethod(QUERY, sub_proc, method);
    CSMTypeAsk(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case NO_DATA:
    *smg = NULL;
    return event;
  default:
    fprintf(stderr, "capsule gets illegal data from substance\n");
    return NO_DATA;
  }
}
int world_info_change_state(int state)
{
  world_info.state[world_info.state_id] = state;
  return world_info.state_id;
}

int world_info_push_state(int state)
{
  world_info.state[++world_info.state_id] = state;
  return world_info.state_id;
}

int world_info_pop_state(void)
{
  return --world_info.state_id;
}

int MethodProcedure(int index, SMessage smg)
{
  int i;
  int type;

  if(index == MSGQ && CSMIsTypeAsk(smg)){
    type = IMPORT;
  }
  if(index == MSGQ && CSMIsTypeReply(smg)){
    type = EXPORT;
  }
  if(index == SIQ && CSMIsTypeAsk(smg)){
    type = SUB_QUERY;
  }
  if(index == SIQ && CSMIsTypeReply(smg)){
    type = SUB_CALL;
  }
  for(i = 0; method_list[i].event_type != -1; i++){
    if(type == method_list[i].event_type &&
       strcmp(CSMGetMethodStr(smg), method_list[i].outer_method)==0) break;
  }
  if(method_list[i].event_type != -1)
    return method_list[i].method_proc(smg);
  else
    return 0;
}

int SelectInnerMethod(int event, char *outer_method, char *inner_method)
{
  int i;
  for(i = 0; method_list[i].event_type != -1; i++){
    if(strcmp(method_list[i].outer_method, outer_method) == 0 &&
       event == method_list[i].event_type) break;
  }
  if(method_list[i].inner_method != NULL){
    strcpy(inner_method, method_list[i].inner_method);
  }
  return i;
}

int select_normal_method(int event_type, char *methods[], int max)
{
  int i, j;
  for(i = 0, j = 0; method_list[i].event_type != -1; i++){
    if(event_type == method_list[i].event_type){
      methods[j++] = strdup(method_list[i].outer_method);
    }
    if(j == max) break;
  }
  return j;
}
int agent_info_init(char *name, char *id, int fd)
{
  strcpy(agent_info.agent_name, name);
  strcpy(agent_info.agent_id, id);
  agent_info.activity = 1;
  agent_info.subFd = fd;
  return 0;
}

/*-----------------------------------------------------------------*/
/* QUERYtoASK(SMessaeg smg) */
int QUERYtoASK(SMessage smg)
{
  CDATA tmps;
  char *data;
  char *inner_method;
  int (*func)(char *data);

  inner_method = CSMGetMethodStr(smg);
  tmps = CCAPSubstanceConvLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CCAPMethodConvCommonEnv(inner_method, tmps);
    CDelete(tmps);
    func = SelectAskProc(EXPORT, inner_method);
    func(data);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from substance to common \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agent_info.activity = EXIT;
  }
  return TRUE;
}

/* ASKtoQUERY */
int ASKtoCALL(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  char call_id[BUFSIZE];
  char errorSmg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CCAPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    CallSubstanceProcedure(data, call_id);
    CREnqueue(smg, EXTERNAL, SUBSTANCE, call_id, OFF);
    free(data);
  }
  else{
    fprintf(stderr, "Convert error from common to substance \n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agent_info.activity = EXIT;
    errorSmg = MakeErrorMessage(smg);
    send_message(errorSmg);
  }
  return TRUE;
}

/* ReplyToResult */
int REPLYtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;

  inner_method = CSMGetMethodStr(smg);
  tmps = CCAPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CCAPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(SUBSTANCE, EXTERNAL, CSMGetMidStr(smg), ON);
    PutResultToSubstance(data, node->procID);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from common to substance.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agent_info.activity = EXIT;
  }
  return TRUE;
}

/* ResultToReply */
int RESULTtoREPLY(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;
  SMessage reply_smg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CCAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CCAPMethodConvCommonEnv(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(EXTERNAL, SUBSTANCE, CSMGetMidStr(smg), ON);
    reply_smg = MakeReplyMessage(node->smg, data);
    send_message(reply_smg);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, "Convert error from substance to common.\n");
    fprintf(stderr, "method = %s\n", inner_method);
    fprintf(stderr, "data   = %s\n", CSMGetDataStr(smg));
    agent_info.activity = EXIT;
    reply_smg = MakeErrorMessage(node->smg);
    send_message(reply_smg);
  }
  return TRUE;
}

int (*SelectAskProc(int mtype, char *inner_method))(char*)
{
  int i;

  for(i = 0; method_list[i].event_type != -1; i++){
    if(method_list[i].event_type == mtype &&
       strcmp(inner_method, method_list[i].inner_method) == 0)
      return method_list[i].send_proc;
  }
  return NULL;
}

/*--------------------------------------------------------------*/
SMessage MakeAskMessage(char *to, char *manage, char *tid, char *method, char *data)
{
  SMessage smg;

  smg = CSMInit();
  CSMTypeAsk(smg);
  CSMPutFromAidStr(smg, PHYSICAL_AGENT_ID);
  CSMResetToMethod(smg);
  if(to != NULL || to[0] != '\0')
    CSMPutToAFStr(smg, to);
  if(manage != NULL || manage[0] != '\0')
    CSMPutToManagementStr(smg, manage);
  CSMPutMethodStr(smg, method);
  CSMPutTidStr(smg, tid);
  CSMPutMethodStr(smg, data);
  return smg;
}

SMessage MakeReplyMessage(char *data, SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "normal");
  CSMPutDataStr(replySmg, data);

  return replySmg;
}

SMessage MakeErrorMessage(SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "error");

  return replySmg;
}

char *CallSubstanceProcedure(char *data, char call_id[])
{
  int id;
  id = call_SICStus_PIPE_substance(data);
  sprintf(call_id, "%d", id++);
  return call_id;
}

int ASK_test(char *data)
{
  SMessage smg;
  smg = MakeAskMessage("test", NULL, NULL, "test", data);
  send_message(smg);
  return 0;
}
