#include <stdio.h>
#include <SMessage.h>

#define BUFSIZE 1024

extern char *PHYSICAL_AGENT_ID;
static char *new_mid()
{
  static int i = 0;
  char buffer[BUFSIZE];
  sprintf(buffer, "%s_%d", PHYSICAL_AGENT_ID, i);
  i = (i+1)%1000;
  return strdup(buffer);
}

SMessage MakeAskMessage(char *to, char *manage, char *tid, char *method, char *data)
{
  SMessage smg;

  smg = CSMInit();
  CSMTypeAsk(smg);
  CSMPutFromAidStr(smg, PHYSICAL_AGENT_ID);
  CSMResetToMethod(smg);
  if(to != NULL || to[0] != '\0')
    CSMPutToAFStr(smg, to);
  if(manage != NULL || manage[0] != '\0')
    CSMPutToManagementStr(smg, manage);
  CSMPutMidStr(smg, new_mid());
  CSMPutMethodStr(smg, method);
  CSMPutTidStr(smg, tid);
  CSMPutMethodStr(smg, data);
  return smg;
}

SMessage MakeReplyMessage(char *data, SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutMidStr(replySmg, CSMGetMidStr(askSmg));
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "normal");
  CSMPutDataStr(replySmg, data);

  return replySmg;
}

SMessage MakeErrorMessage(SMessage askSmg)
{
  SMessage replySmg;

  replySmg = CSMInit();
  CSMTypeReply(replySmg);
  CSMResetToMethod(replySmg);
  CSMPutToAFStr(replySmg, CSMGetFromAidStr(askSmg));
  CSMPutToManagementStr(replySmg, NULL);
  CSMPutToMidStr(replySmg, CSMGetMidStr(askSmg));
  CSMPutMethodStr(replySmg, CSMGetMethodStr(askSmg));
  CSMPutStatusStr(replySmg, "error");

  return replySmg;
}
  
