#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <helios/event.h>

#define BUFSIZE 1024

#define NO_DATA  0
#define QUERY    1
#define REQUEST  2
#define RESULT   3

typedef struct {
  int  type;
  char *id;
  int  len;
} data_table;
data_table data_type[]={ { QUERY,   "query:",   6, },
			 { RESULT,  "result:",  7,},
			 { REQUEST, "request:", 8, },
			 { NO_DATA, (char *)NULL, 0 } };

static char *call_file = "[../../../substance/call.pl].\n";

static char *check_data_type(char *buf, data_table dt);

extern int init_SICStus_PIPE_substance(char *path,
				       char *agent_name,
				       char* substance);
extern int exit_SICStus_PIPE_substance(void);
extern int call_SICStup_PIPE_substance(char *predicate);
extern int getdata_SICStus_PIPE_substance(char *sub_proc, char *data, char* id);
extern int put_result_to_SICStup_PIPE_substance(char *result);

static int pipe_1[2], pipe_2[2];
static char *buf;

init_SICStus_PIPE_substance(char *path, char *agent_name, char *substance)
{
  int pid;
  char file[100];
  
  /* $B<B$HHi$NDL?.$N$?$a!"%Q%$%W$r3+$/(B */
  if(pipe(pipe_1) < 0){
    perror("pipe");
    return -1;
  }
  
  if(pipe(pipe_2) < 0){
    perror("pipe");
    return -1;
  }
  
  if((pid = fork()) <0){
    perror("fork");
    return -1;
  }
  
  /* $B;R%W%m%;%9$H$7$F<B$H$J$k(B Prolog $B$r5/F0$9$k(B */
  if(pid == 0){
    close(0);
    dup(pipe_1[0]);
    close(pipe_1[0]);
    close(1);
    dup(pipe_2[1]);
    close(pipe_2[1]);
    
    close(pipe_2[0]);
    close(pipe_1[1]);
#ifdef SUB
#else
    close(2);
#endif
    sprintf(file, "%s/%s", path, "SIStus");
    execl(file, agent_name, "-l", substance, NULL, 0);
  }
  close(pipe_1[0]);
  close(pipe_2[1]);

  write(pipe_1[1], call_file, strlen(call_file));
  /* $BDL?.It$K(B pipe_2[0] $B$+$i$NF~NO$r%$%Y%s%H$H$7$FEPO?$9$k(B */
  register_fd(pipe_2[0], FD_EV_READ);
  
  return pipe_2[0];
}

int exit_SICStus_PIPE_substance(void)
{
  int pid;

  /* $BJV?.BT$A$N<B$b=*N;$5$;$k$?$a!":G=i$K(B abort $B$r<B$KAw$k!#(B */
  /* abort $B$K$h$j(B Prolog $B$N=hM}$,=*N;$7$?;~E@$G(B halt $B$rAw$k!#(B*/
  write(pipe_1[1], "abort.\n", strlen("abort.\n"));
  write(pipe_1[1], "halt.\n", strlen("halt.\n"));
  
  /* $B<B$HHi$N4V$N%Q%$%W$rJD$8$k(B */
  close(pipe_1[1]);
  close(pipe_2[0]);
  
  while(wait((int *) 0) != pid);
  return 0;
}

/*
  $B<B$N=hM}$N8F$S=P$7(B
  $B=hM}A*Br$d7?JQ49$G8F$S=P$7$?$$=R8l$N7A$K$^$GJQ49$5$l$F$$$k$b$N$H$9$k!#(B
  */
int call_SICStus_PIPE_substance(char *predicate)
{
  static int call_id = 0;

  write(pipe_1[1], "call_application(", strlen("call_application("));
  write(pipe_1[1], predicate, strlen(predicate));
  write(pipe_1[1], ").\n", strlen(").\n"));
  return call_id++%1000;
}

int put_result_to_SICStup_PIPE_substance(char *result)
{
  if(write(pipe_1[1], result, strlen(result)) >= 0){
    if(write(pipe_1[1], ".\n", strlen(".\n")) >= 0){
      return 1;
    } else {
      return 0;
    }
  } else {
    return 0;
  }
}

/*
 * $B<B$+$i$N%G!<%?$N<u$1<h$j(B
 */
int getdata_SICStus_PIPE_substance(char *sub_proc, char *data, char *id)
{
  int i, n;
  static int query_id = 0;
  char query[20];
  static int flag = 0;
  static char buf[BUFSIZE], *head, *tail, *tmp, *sep;
  
  if(flag == 0){
    memset(buf, 0, BUFSIZE);
    n = read(pipe_2[0], buf, BUFSIZE);
    if(n == 0){
      return NO_DATA;
    }
    else{
      head = buf;
      flag = 1;
    }
  }
  tail = strchr(head, '\n');
  if(tail != NULL){
    for(tmp = head, *tail = '\0', i = 0; data_type[i].id != (char *)NULL; i++){
      if((head = check_data_type(tmp, data_type[i])) != NULL){
	sep = strchr(head, '@');
	*sep++ = '\0';
	strcpy(sub_proc, head);
	strcpy(data, sep);
	break;
      }
    }
    if(*(tail + 1) == NULL){
      head = tail - 1;
    }
    else{
      head = tail + 1;
    }
    if(data_type[i].type == QUERY){
      sprintf(id, "%d", query_id++);
      sprintf(query, "query_id(%s).\n", id);
      write(pipe_1[1], query, strlen(query));
    }
    else if(data_type[i].type == REQUEST){
      sprintf(id, "%s", data);
    }
    return data_type[i].type;
  } else {
    flag = 0;
    return NO_DATA;
  }
}

/*
  $B<B$+$i$N%G!<%?$N<u$1<h$j$N8!=P(B
  */
int check_data_from_application(void)
{
  int i, j, n;
  char tmp[BUFSIZE], *head;
  
  n = read(pipe_2[0], tmp, BUFSIZE);
  *(tmp+n-1) = '\0';
  for(i = 0; data_type[i].id != (char *)NULL; i++) {
    if((head = check_data_type(tmp, data_type[i])) != NULL) {
      break;
    }
  }
  if(buf != (char *)NULL) free(buf);
  if(data_type[i].id != (char *)NULL) {
    buf = (char *)malloc(sizeof(char) * (n - data_type[i].len + 1));
    for(j = 0; j < (n - data_type[i].len); j++) {
      *(buf+j) = tmp[data_type[i].len +j];
    }
    *(buf+j) = '\0';
    return data_type[i].type;
  } else {
    buf = NULL;
    return data_type[i].type;
  }
}

static char *check_data_type(char *buf, data_table dt)
{
  char *head;
  
  head = buf;
  while(*buf == *dt.id) {
    buf++;
    dt.id++;
  }
  if(*dt.id == '\0') {
    return buf;
  } else {
    return (char *)NULL;
  }
}

/* end of CAPofSICSagent.c */
