/* CRecord.h
 *    header file for handling a record in capsule.
 *
 */

#include "CRNode.h"

#define EXTERNAL    0
#define SUBSTANCE   1
#define NEGOTIATION 2
#define PROCEDURE   3

#define FALSE 0
#define FAIL  0
#define TRUE  1

#define OFF 0
#define ON  1

#ifndef __CRecord__
#define __CRecord__

typedef struct _CRecordM {
  CRNode head;
  CRNode tail;
} CRecordM;

typedef CRecordM *CRecord;

extern CRecord record;

extern CRecord CRecordNew(void);
extern int CRecordInit(void);
extern int
  CREnqueue(SMessage smg, int src, int dist, int world, char *procID, int flag);
extern int CRSetSubstanceReqFlagOn(char *methodID);
extern int CRMultiSelect(int src, int dist, int world, char *procID, char *methodID[]);

#endif __CRecord__
/* end of CaplRecord.h */
