/* CaplRecord.c
 *        $B30It!&<B!&<jB3$-$+$i$NLd$$9g$o$;$KBP$9$k=hM}$r5-O?$9$k!#(B
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "CRecord.h"

static CRecord record;

CRecord
  CRecordNew(void)
{
  CRecord new;

  new = (CRecord)malloc(sizeof(CRecordM));
  new->head = (CRNode)NULL;
  new->tail = (CRNode)NULL;
  return new;
}

int
  CRecordInit(void)
{
  CRNFree(record->head);
  record->head = (CRNode)NULL;
  record->tail = (CRNode)NULL;
  return 0;
}

int
  CREnqueue(SMessage smg, int src, int dist, int world, char *procID, int flag)
{
  CRNode new, tail;
  new = CRNNew(smg, src, dist, world, procID, flag);
  tail = record->tail;
  new->front = tail;
  new->rear = (CRNode)NULL;
  tail->rear = new;
  return 0;
}

int
  CRDequeue(int src, int dist, int world, char *procID, char *mid, char *method, int flag)
{
  CRNode node;
  node = CRNSelect(record->head, src, dist, world, procID, mid, method, flag);
  if(node != NULL){
    CRNDelete(node);
    return 1;
  }
  else{
    return 0;
  }
}

int CRSetSubstanceReqFlagOn(char *methodID)
{
  CRNode node;
  node = CRNSelect(record->head, SUBSTANCE, -1, -1, NULL, methodID, NULL, OFF);
  if(node != (CRNode)NULL){
    node->flag = ON;
    return TRUE;
  }
  else{
    return FAIL;
  }
}

int CRMultiSelect(int src, int dist, int world, char *procID, char *methodID[])
{
  CRNode node;
  int i;
  for(i = 0, node = record->head; node != NULL;){
    node = CRNSelect(node, src, dist, world, procID, NULL, NULL, ON);
    if(node != NULL){
      methodID[i++] = strdup(CSMGetMidStr(node->smg));
    }
  }
  methodID[i] = NULL;
  return i;
}

CRNode CRSelect(int src, int dist, int world, char *procID, char *mid, int flag)
{
  return CRNSelect(record->head, src, dist, world, procID, mid, NULL, flag);
}

/* end of CRecord.c */
