/* CRNode.h
 *    header file for handling nodes of a record in capsule.
 *
 */
#include <helios/SMessage.h>

#define BUFSIZE 1024
#define UNKNOWN -1
#define ONOFF   -1
#define OFF 0
#define ON  1
#define FALSE 0
#define FAIL  0
#define TRUE  1

#ifndef __CRNode__
#define __CRNode__

#define TopToTail 0
#define TailToTop 1

typedef struct _CRNodeM {
  int      src;
  int      dist;
  int      flag;
  int      world;
  SMessage smg;
  char     procID[BUFSIZE];
  struct _CRNodeM *front;
  struct _CRNodeM *rear;
} CRNodeM;

typedef CRNodeM *CRNode;

extern int CRNFree(CRNode node);
extern int CRNDelete(CRNode node);
extern CRNode CRNNew(SMessage smg, int src, int dist, int world, char *procID, int flag);
extern CRNode CRNSelect(CRNode node, int src, int dist, int world,
			char *procID, char *mid, char *method, int flag);


#endif __CRNode__

/* end of CRNode.h */

