/* CRNode.c
 *    module for handling nodes of a record in capsule.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <helios/SMessage.h>
#include "CRNode.h"

CRNode
  CRNNew(SMessage smg, int src, int dist, int world, char *procID, int flag)
{
  CRNode new;

  new = (CRNode)malloc(sizeof(CRNodeM));
  new->smg = smg;
  strcpy(new->procID, procID);
  new->src = src;
  new->dist = dist;
  new->world = world;
  new->flag = flag;
  new->front = (CRNode)NULL;
  new->rear = (CRNode)NULL;
  return new;
}

int
  CRNFree(CRNode node)
{
  if(node != (CRNode)NULL){
    CRNFree(node->rear);
  }
  free(node);
  return 0;
}

int
  CRNDelete(CRNode node)
{
  if(node != (CRNode)NULL){
    if(node->front != (CRNode)NULL){
      node->front->rear = node->rear;
    }
    if(node->rear != (CRNode)NULL){
      node->rear->front = node->rear;
    }
    free(node);
  }
  return 0;
}

CRNode
  CRNSelect(CRNode node, int src, int dist, int world, char *procID,
	    char *mid, char *method, int flag)
{
  int swt;

  swt = 0;
  if(node != (CRNode)NULL){
    if(method != (char *)NULL
       && strcmp(method, CSMGetMethodStr(node->smg)) != 0) swt = 1;

    if(swt == 0 && mid != (char *)NULL
       && strcmp(mid, CSMGetMidStr(node->smg)) != 0) swt = 1;

    if(swt == 0 && src != UNKNOWN && src != node->src) swt = 1;
    if(swt == 0 && dist != UNKNOWN && dist != node->dist) swt = 1;

    if(swt == 0 && procID != (char *)NULL
       && strcmp(procID, node->procID) != 0) swt = 1;

    if(swt == 0 && flag != ONOFF && flag != node->flag) swt = 1;
    if(swt == 0)
      return node;
    else
      return CRNSelect(node->rear, src, dist, world, procID, mid, method, flag);
  }
  else{
    return (CRNode)NULL;
  }
}

/* end of CRNode.c */
