/* CQueue.h
 *    header file of capl compiler for handling a queue in capsule.
 *
 */

#include "CQNode.h"

#ifndef __CQueue__
#define __CQueue__
#define FALSE 0
#define FAIL  0
#define TRUE  1

typedef struct _CQueueM {
  CQNode head;
  CQNode tail;
}CQueueM;

typedef CQueueM* CQueue;

extern CQueue queue[3];

extern CQueue CQNew(void);
extern int CQEmpty(CQueue);
extern int CQEnqueue(CQueue, SMessage smg);
extern SMessage CQDequeue(CQueue queue, int type,
			  char** mid, char* tid, char **methodList);
#endif __CQueue__
/* end of CQueue.h */
