/* CQueue.c
 *    module of capl compiler for handling a queue in capsule.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "CQueue.h"

CQueue queue[3];

CQueue
  CQNew(void)
{
  CQueue new;
  new = (CQueue)malloc(sizeof(CQueueM));
  new->head = (CQNode)NULL;
  new->tail = (CQNode)NULL;
  return new;
}

int
  CQEmpty(CQueue queue)
{
  if(queue->head == (CQNode)NULL && queue->tail == (CQNode)NULL)
    return TRUE;
  else
    return NULL;
}

int
  CQEnqueue(CQueue queue, SMessage smg)
{
  CQNode new, tail;

  tail = queue->tail;
  new = CQNodeNew(smg);
  new->front = tail;
  new->rear = (CQNode)NULL;
  tail->rear = new;
  return TRUE;
}

SMessage
  CQDequeue(CQueue queue, int type, char** mid, char* tid, char **methodList)
{
  CQNode node;
  SMessage smg;
  node = CQNSelect(queue->head, type, mid, tid, methodList);
  if(node != NULL){
    smg = node->smg;
    CQNodeDelete(node);
    return smg;
  }
  else{
    return (SMessage)smg;
  }
}

/* end of CQueue.c */
