/* CQNode.h
 *    header file of capl compiler for handling nodes of a queue in capsule.
 *
 */
#include <helios/SMessage.h>

#ifndef __CaplQueueNode__
#define __CaplQueueNode__

typedef struct _CQNodeM {
  SMessage smg;
  struct _CQNodeM *front;
  struct _CQNodeM *rear;
} CQNodeM;

typedef CQNodeM* CQNode;

extern CQNode CQNodeNew(SMessage);
extern int CQNodeDelete(CQNode node);
extern int CQNodeFree(CQNode node);
extern CQNode CQNSelect(CQNode node, int type,
			char** mid, char* tid, char **methodList);

#endif __CaplQueueNode__

/* end of CQNode.h */
