%
%
%  file name : queen.pl
%

:- ['/db/HKB/ifs/system/src/cap/call.pl'].

%% public predicate

init:- 
  abolish(current_av_pos,1).

%
% receive_pos/2
%
receive_pos(PosList,Result):-
  get_num_of_element(PosList,Num),
  get_available_pos_list(PosList,AvList),
  assert(current_av_pos(AvList)),
  ( Num = 3 -> terminal_queen(PosList,Result);
    session_loop(PosList,Result) ).

session_loop(PosList,Result):-
  current_av_pos(AvList),
  get_candidate_pos(AvList,Pos,NewAvList),
  session_loop1(Pos,PosList,NewAvList,Result).

session_loop1(0,_,_,[]).
session_loop1(Pos,PosList,NewAvList,Result):-
    abolish(current_av_pos,1),
    assert(current_av_pos(NewAvList)),
    append(PosList,[Pos],SendPosList),
    ex_query(send_pos(SendPosList,Reply)),
    check_reply(Reply,Ans),
    ( Ans = ok -> Reply = Result;
      session_loop(PosList,Result) ).


terminal_queen(PosList,Result):-
  current_av_pos(AvList),
  get_candidate_pos(AvList,Pos,NewAvList),
  ( Pos = 0 -> Result = [];
    abolish(current_av_pos,1),
    assert(current_av_pos(NewAvList)),
    append(PosList,[Pos],Result) ).


get_available_pos_list([],[1,2,3,4]).
get_available_pos_list(PosList,AvList):-
  get_num_of_element(PosList,Num),
  MyCol is Num + 1,
  get_available_pos_list1(PosList,1,MyCol,[1,2,3,4],AvList).

get_available_pos_list1([],_,_,AvList,AvList).
get_available_pos_list1([H|T],Hpos,MyCol,TmpAv,AvList):-
  del_element(TmpAv,H,TmpAv1),
  Dif is MyCol - Hpos,
  DelPos1 is H - Dif, DelPos2 is H + Dif,
  del_element(TmpAv1,DelPos1,TmpAv2),
  del_element(TmpAv2,DelPos2,TmpAv3),
  Hpos1 is Hpos + 1,
  get_available_pos_list1(T,Hpos1,MyCol,TmpAv3,AvList).

del_element(AvList,E,NewAvList):- E < 1, !,
  NewAvList = AvList.
del_element(AvList,E,NewAvList):- E > 4, !,
  NewAvList = AvList.
del_element(AvList,E,NewAvList):-
  del_element1(AvList,E,[],NewAvList).

%del_element1([],_,NewAvList,NewAvList).
del_element1([],_,Tmp,NewAvList):-
  rev(Tmp,NewAvList).
del_element1([H|T],H,Tmp,NewAvList):-
  del_element1(T,H,Tmp,NewAvList).
del_element1([H|T],E,Tmp,NewAvList):-
  Tmp1 = [H|Tmp],
  del_element1(T,E,Tmp1,NewAvList).


check_reply([],no).
check_reply(_,ok).

get_candidate_pos([],0,[]).
get_candidate_pos([H|T],H,T).


get_num_of_element(List,Num):-
  get_num_of_element1(List,0,Num).

get_num_of_element1([],Num,Num).
get_num_of_element1([_|T],Tmp,Num):-
  Tmp1 is Tmp + 1,
  get_num_of_element1(T,Tmp1,Num).


append([],Y,Y).
append([H|T],Y,[H|Z]):- append(T,Y,Z).


rev(X,Z):- rev1(X,[],Z).

rev1([],Z,Z).
rev1([H|T],Tmp,Z):- rev1(T,[H|Tmp],Z).


%%% for dbg %%%
%ex_query(send_pos(SendPosList,Reply)):-
%  write('send_pos = '), write(SendPosList), nl,
%  read(Reply).

%%% END OF FILE %%%
