#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Vendor.h>

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>

#ifdef XI18N
#include <X11/Xaw/Xawi18n.h>
#endif /* XI18N */

#include "module.h"

static Widget ruleShell = 0, title, view, ruleBox;
static Widget toggle[2];
static WidgetList ruleW = NULL;
static int n_wid = 0;
extern char *menu_label[];

static void makeCommandBox();

static Widget
createRuleShell(parent)
Widget parent;
{
    Widget shell, pane, form, box;
    extern char **rule;
    
    shell = XtVaCreatePopupShell("Module Rules",
				 vendorShellWidgetClass,
				 parent,
				 XtNallowShellResize, True,
				 NULL);
    pane = XtVaCreateManagedWidget("pane", panedWidgetClass, shell, 
				    NULL);

    title = XtVaCreateManagedWidget("title", labelWidgetClass, pane,
				    XtNborderWidth, 0,
				    NULL);

    box = XtVaCreateManagedWidget("box", boxWidgetClass, pane,
				     NULL);
    makeCommandBox(box);

    form = XtCreateManagedWidget("form", formWidgetClass, pane,
				 NULL, 0);

    view = XtVaCreateManagedWidget("view", viewportWidgetClass, form, 
				   XtNtop, XawChainTop, 
				   XtNbottom, XawChainBottom, 
				   XtNleft, XawChainLeft, 
				   XtNright, XawChainRight, 
				   XtNallowVert, TRUE,
				   XtNallowHoriz, TRUE,
				   NULL);

    ruleBox = XtVaCreateManagedWidget("ruleBox", formWidgetClass, view,
				    NULL);
    XtRealizeWidget(shell);
    return(shell);
}

static void
setRule(w, rule_type, call_data)
Widget w;
int rule_type;
XtPointer call_data;
{
    char label[128];
    static int sav_node = -1;
    extern int cur_node;
    extern char **rule;
    Node *p = node[cur_node];
    int sidx, cnt, i;

    if (XawToggleGetCurrent(toggle[0]) == NULL)
	return;
    /* set title */
    if (cur_node != sav_node) {
	sprintf(label, "<%s>", NODENAME(p));
	XtVaSetValues(title, XtNlabel, label, NULL);
	
	/* set toggle button sensitivity */
	XtVaSetValues(toggle[0], 
		      XtNsensitive, (p->uRuleCnt > 0) ? True : False, 
		      NULL);
	XtVaSetValues(toggle[1], 
		      XtNsensitive, (p->nRuleCnt > 0) ? True : False, 
		      NULL);
	sav_node = cur_node;
    }
    /* set rule */
    if (rule_type == 0) {		/* User's Rule */
	sidx = p->uRuleId;
	cnt = p->uRuleCnt;
    } else {			/* Normalized Rule */
	sidx = p->nRuleId;
	cnt = p->nRuleCnt;
    }
    if (n_wid > 0)
	XtUnmanageChildren(ruleW, n_wid);
    if (n_wid < cnt) {
	ruleW = (WidgetList)XtRealloc(ruleW, sizeof(Widget) * cnt);
	for (; n_wid < cnt; n_wid++) {
	    ruleW[n_wid] = XtVaCreateWidget("rule", labelWidgetClass, ruleBox, 
					     XtNborderWidth, 0, NULL);
	}
    }
    for (i = 0; i < cnt; i++) {
	XtVaSetValues(ruleW[i], 
		      XtNfromVert, i==0 ? NULL : ruleW[i-1],
		      XtNlabel, rule[sidx+i], NULL);
    }
    XtManageChildren(ruleW, cnt);

    XawViewportSetCoordinates(view, 0, 0);
}

void 
ShowRule(w, mid, call_data)
Widget w;
int mid;
XtPointer call_data;
{
    if (ruleShell == 0)
	ruleShell = createRuleShell(toplevel);

    if (XawToggleGetCurrent(toggle[0]))
	XawToggleUnsetCurrent(toggle[0]);
    XawToggleSetCurrent(toggle[0], menu_label[mid]);

    XtPopup(ruleShell, XtGrabNone);
}

static void
Close()
{
    XtPopdown(ruleShell);
}

static void
makeCommandBox(parent)
Widget parent;
{
    Widget close;
    register int i;

    /* toggle select type is one of many */
    static char toggle_translation_table[] =
        "<EnterWindow>:       highlight(Always)\n\
     	 <LeaveWindow>:       unhighlight()\n\
         <Btn1Down>,<Btn1Up>: set() notify()";
    XtTranslations trans = XtParseTranslationTable(toggle_translation_table);

    close = XtVaCreateManagedWidget("close", commandWidgetClass, parent, 
				    NULL);
    XtAddCallback(close, XtNcallback, Close, (caddr_t)0);

    for (i = 0; i < 2; i++) {
	toggle[i] = XtVaCreateManagedWidget("toggle",
					 toggleWidgetClass, 
					 parent,
					 XtNlabel, menu_label[i],
					 XtNradioData, menu_label[i],
					 XtNradioGroup, i>0 ? toggle[0] : NULL,
					 XtNtranslations, trans,
					 NULL);
	XtAddCallback(toggle[i], XtNcallback, setRule, (XtPointer)i);
    }
}

