#include "lattice.h"

#include <X11/Shell.h>
#include <X11/Vendor.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>

#ifdef XI18N
#include <X11/Xaw/Xawi18n.h>
#endif /* XI18N */

static Widget searchShell = 0;

static int current = -1;

/* 
 * ֥̾Υơ֥
 */
typedef struct _ObjTbl {
    int  widx;			/* wlist  index */
    unsigned char *name;	/* ̾ */
} ObjTbl;

ObjTbl *objtbl;

/*
 * Close
 *	ɥĤ
 */
static void
Close()
{
    extern Widget search_toggle;

    /* ƤΡɤä鸵᤹ */
    if (current >= 0)
	InvertObject(wlist[current], False);
    /* ᥤ󥦥ɥΥȥܥ򤷤Ƥʤ֤᤹ */
    XtVaSetValues(search_toggle, XtNstate, False, NULL);

    /* ɥݥåץ󤹤 */
    XtPopdown(searchShell);
}

static
makeCommandBox(parent)
Widget parent;
{
    Widget close;

    /* ܥ */
    close = XtVaCreateManagedWidget("close", commandWidgetClass, parent, 
				    NULL);
    /* ܥ󤬲줿ΥХåؿꤹ */
    XtAddCallback(close, XtNcallback, Close, (caddr_t)0);
}

static
compare(s1, s2)
ObjTbl *s1, *s2;
{
    return(strcmp(s1->name, s2->name));
}

/*
 * SelectObject
 *	륪֥̾򤷤ν
 */
static void
SelectObject(w, unused_1, unused_2)
Widget w;
caddr_t unused_1;
caddr_t unused_2;
{
    XawListReturnStruct *list_return;

    /* ΥΡɤȿž᤹ */
    if (current >= 0) 
	InvertObject(wlist[current], False);

    /* ɤΥꥹȤФ줿ΤĴ٤ */
    list_return = XawListShowCurrent(w);
    
    /* Ф줿ꥹȤΥǥå wlist Υǥå */
    current = objtbl[list_return->list_index].widx;

    /* Ф줿֥Ȥ widget ȿž */
    InvertObject(wlist[current], True);
}

/*
 * makeList
 *	ѤΥơ֥
 */
static
makeList(parent)
Widget parent;
{
    Widget list;
    register int i;
    unsigned char **objlist;

    /* ΡɿʬΥꥢݤ */
    objtbl = (ObjTbl *) XtMalloc (sizeof(ObjTbl) * n_node);
    /* wlist  index ȥΡ̾򥻥åȤ */
    for (i = 0; i < n_node; i++) {
	objtbl[i].widx = i;
	objtbl[i].name = NODENAME(node[i]);
    }
    /* ʸɽ˥Ȥ */
    qsort((char *)objtbl, n_node, sizeof(ObjTbl), compare);

    /* list widget ˥åȤ뤿Υ֥̾Υơ֥ */
    objlist = (unsigned char **) XtMalloc(sizeof(unsigned char *) * n_node);
    for (i = 0; i < n_node; i++) {
	objlist[i] = objtbl[i].name;
    }
    /* list widget  */
    list = XtVaCreateManagedWidget("searchList", listWidgetClass, parent, 
				   XtNlist, objlist,
				   XtNnumberStrings, n_node,
				   NULL);
    /* ƥ֥Ȥ򤵤줿ΥХåؿ򥻥åȤ */
    XtAddCallback(list, XtNcallback, SelectObject, NULL);
}

/*
 * createSearchShell
 *	ѤΥɥ
 */
static Widget
createSearchShell(parent)
Widget parent;
{
    Widget shell, pane, form, box, view, list;

    shell = XtVaCreatePopupShell("Search",
				 vendorShellWidgetClass,
				 parent,
				 XtNallowShellResize, True,
				 NULL);
    pane = XtVaCreateManagedWidget("pane", panedWidgetClass, shell, 
				    NULL);

    box = XtVaCreateManagedWidget("commandbox", boxWidgetClass, pane,
				  XtNorientation, XtorientHorizontal,
				  NULL);
    makeCommandBox(box);

    form = XtCreateManagedWidget("form", formWidgetClass, pane,
				 NULL, 0);

    view = XtVaCreateManagedWidget("view", viewportWidgetClass, form, 
				   XtNallowVert, TRUE,
				   XtNallowHoriz, TRUE,
				   NULL);
    makeList(view);
    return(shell);
}

/*
 * SearchObject
 *	ᥤ󥦥ɥ search Ф줿ν
 */
void
SearchObject(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
    Boolean toggle_on;

    /* ᥤ󥦥ɥΥȥܥΥơĴ٤ */
    XtVaGetValues(w, XtNstate, &toggle_on, NULL);

    if (toggle_on) {	/* on  */
	if (searchShell == 0)
	    searchShell = (Widget)createSearchShell(toplevel);
	/* ɥݥåץåפ */
	XtPopup(searchShell, XtGrabNone);
    } else {		/* off */	
	/* ɥݥåץ󤹤 */
	XtPopdown(searchShell);
    }
}

/*
 * InvertObject
 *	Ϳ줿 widget ȿž
 */	
InvertObject(w, invert)
Widget w;
Boolean invert;
{
    static Pixel fore = 0, back = 0;
    Position x, y;

    if (fore == 0 && back == 0) 
	XtVaGetValues(w, XtNforeground, &fore, XtNbackground, &back, NULL);

    if (invert)		/* ȿž */
	XtVaSetValues(w, XtNforeground, back, XtNbackground, fore, NULL);
    else		/* ȿž᤹ */
	XtVaSetValues(w, XtNforeground, fore, XtNbackground, back, NULL);

    XtVaGetValues(w, XtNx, &x, XtNy, &y, NULL);
    MoveLattice(x-50, y-50);
}
