#include "lattice.h"

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>	

#include <X11/Xaw/Label.h>

#ifdef XI18N
#include <X11/Xaw/Xawi18n.h>
#endif /* XI18N */

#include "Lattice.h"

static int wrap, maxlen;

/*
 * ץꥱ꥽
 */
static XtResource my_resources[] = {
/* ֥̾ޤʤ֤λ */
    {"wrapCount", "WrapCount", XtRInt, sizeof(int),
	 (Cardinal) &wrap, XtRImmediate, (XtPointer)0},
/* ֥̾κɽʸ */
    {"maxLength", "MaxLength", XtRInt, sizeof(int),
	 (Cardinal) &maxlen, XtRImmediate, (XtPointer)0},
};

static void 	PannerCallback(),
    		PortholeCallback();
static makeCommandBox(), makeLattice();
static Widget lattice, panner, porthole;

WidgetList wlist;
Widget search_toggle;

/*
 * GetAppResources
 * 	ץꥱΥ꥽
 */
GetAppResources()
{
    XtGetApplicationResources(toplevel, (caddr_t) NULL,	my_resources,
			      XtNumber(my_resources), NULL, 0);
}

/*
 * CreateWidgets
 *	ᥤΥɥ
 */
CreateWidgets()
{
    Widget vPane, hPane, box;

    vPane = XtCreateManagedWidget("vPane", panedWidgetClass, toplevel, 
				  NULL, 0);
    hPane = XtVaCreateManagedWidget("hPane", panedWidgetClass, vPane, NULL);

    panner = XtVaCreateManagedWidget("panner", pannerWidgetClass, hPane, NULL);

    box = XtCreateManagedWidget("box", boxWidgetClass, hPane, NULL, 0);
    makeCommandBox(box);

    porthole = XtVaCreateManagedWidget("porthole", portholeWidgetClass,
				       vPane, NULL);
    /*
     * Allow the panner and porthole to talk to each other.
     */
    XtAddCallback(porthole, 
		  XtNreportCallback, PortholeCallback, (XtPointer) panner);
    XtAddCallback(panner, 
		  XtNreportCallback, PannerCallback, (XtPointer) porthole);

    lattice = XtVaCreateManagedWidget("lattice", QxtlatticeWidgetClass, 
				      porthole,
				      NULL);
    makeLattice(lattice);
}

static void
Quit()
{
    exit(0);
}

static
makeCommandBox(parent)
Widget parent;
{
    Widget quit;
    extern void SearchObject();

    /* λ(quit)ܥ */
    quit = XtVaCreateManagedWidget("quit", commandWidgetClass, parent, 
				   NULL);
    XtAddCallback(quit, XtNcallback, Quit, (caddr_t)0);

    /* (search)ȥܥ */
    search_toggle = XtVaCreateManagedWidget("search", toggleWidgetClass, 
					    parent, NULL);
    XtAddCallback(search_toggle, XtNcallback, SearchObject, (caddr_t)0);
}

/*
 * formatString
 *	str  wrap, truncate νԤ
 */
static char *
formatString(str)
unsigned char *str;
{
    static char buf[BUFSIZ];
    int n = 0, len = strlen(str), wl, i;
    Boolean kanji1;

    /* ĹΥå */
    if (maxlen > 0 && len > maxlen) {
	for (i = 0, kanji1 = False; i < maxlen; i++) {
	    /* Υå */
	    if (kanji1 == True)
		kanji1 = False;
	    else if (str[i]&0x80)
		kanji1 = True;
	}
	/* ʤ 1byte ץ饹 */
	if (kanji1)
	    i++;
	len =i;
    }

    /* ޤʤ */
    if (wrap == 0)
	(void)strcpy(buf, str);
    else {
	buf[0] = '\0';
	wl = wrap;
	while (1) {
	    if (n+wl < len) {
		for (i = 0, kanji1 = False; i < wl; i++) {
		    /* Υå */
		    if (kanji1 == True)
			kanji1 = False;
		    else if (str[n+i]&0x80) 
			kanji1 = True;
		}
	    }
	    /* ʤ 1byte ץ饹 */
	    if (kanji1)
		wl++;
	    (void)strncat(buf, &str[n], MIN(len,wl));
	    if ((n+=wl) >= len)
		break;
	    /* Ԥ */
	    (void)strcat(buf, "\n");
	}
    }
    return(buf);
}

/*
 * makeLattice
 *	lattice ¤κ
 * 	ƥΡɤ widget ƥ꥽򥻥åȤ
 */
static 
makeLattice(lw)
Widget lw;
{
    register int i, j;

    /* ƥΡɤ widget ѤΥꥢ alloc  */
    wlist = (WidgetList)XtMalloc(sizeof(Widget)*n_node);
    /* ƥΡ widget  */
    for (i = 0; i < n_node; i++) {
	wlist[i] = XtVaCreateWidget("node", labelWidgetClass, lw, 
			XtNlabel, formatString(NODENAME(node[i])),
			NULL);
    }
    /* ƥΡ widget ˿ƤΥ꥽ꤹ */
    for (i = 0; i < n_node; i++) {
	WidgetList wl;

	if (node[i]->n_parents == 0)
	    continue;
	wl = (WidgetList)XtMalloc(sizeof(Widget)*node[i]->n_parents);
	for (j = 0; j < node[i]->n_parents; j++) {
	    wl[j] = wlist[node[i]->parents[j]];
	}
	XtVaSetValues(wlist[i], XtNparents, wl, 
		      XtNnumParents, node[i]->n_parents, NULL);
    }
    /* ޥ͡ */
    XtManageChildren(wlist, n_node);
}

static void 
PannerCallback(w, closure, report_ptr)
Widget w;
XtPointer closure, report_ptr;
{
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtVaSetValues(lattice, XtNx, -report->slider_x,
		  XtNy, -report->slider_y, NULL);
}

static void 
PortholeCallback(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
{
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtSetArg (args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg (args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) {
	XtSetArg (args[n], XtNsliderWidth, report->slider_width); n++;
	XtSetArg (args[n], XtNsliderHeight, report->slider_height); n++;
	XtSetArg (args[n], XtNcanvasWidth, report->canvas_width); n++;
	XtSetArg (args[n], XtNcanvasHeight, report->canvas_height); n++;
    }
    XtSetValues (panner, args, n);
}

MoveLattice(x, y)
{
    XtVaSetValues(panner, XtNsliderX, x, XtNsliderY, y, NULL); 
    XtVaSetValues(lattice, XtNx, -x, XtNy, -y, NULL);
}
