#include <stdio.h>
#include <X11/Xlocale.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/XawIm.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/CommandLc.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <ctype.h>


static String fallback_resources[] = {
    "*fontSet: -*-*-medium-*-*--14-*",
/*    "*font: -*-*-medium-r-normal--24-*-*-*-*-*-iso8859-1",*/
    (char *) NULL,
};

XtAppContext app_con;
Widget toplevel;
static Widget form;

static void quit(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    exit (0);
}

static void button_callback(widget, closure, data)
    Widget widget;
    caddr_t closure;
    caddr_t data;
{
    extern int build_tree();

    if (closure != NULL)
	(void)build_tree(closure);
}

static void create_win()
{
    Widget pane, box, view;
    Arg args[4];
    static XtCallbackRec callback_rec[2] = {{quit, NULL}, {NULL, NULL}};
    
    pane = XtCreateManagedWidget("pane", panedWidgetClass, toplevel,
				 (ArgList) NULL, ZERO);
    box = XtCreateManagedWidget("buttonbox", boxWidgetClass, pane,
				(ArgList) NULL, ZERO);
    XtSetArg(args[0], XtNcallback, callback_rec);
    XtSetArg(args[1], XtNlabel, "Quit");
    (void)XtCreateManagedWidget("quit", commandLocaleWidgetClass, box,
				args, TWO);
    XtSetArg(args[0], XtNallowHoriz, True);
    XtSetArg(args[1], XtNallowVert, True);
    XtSetArg(args[2], XtNshowGrip, False);
    view = XtCreateManagedWidget("view", viewportWidgetClass, pane,
				       args, THREE);
    form = XtCreateManagedWidget("form", formWidgetClass, view,
				       (ArgList) NULL, ZERO);
}

static void create_button(name, addr)
    String name;
    char *addr;
{
    static Widget chain = NULL;
    Arg args[10];
    static XtCallbackRec callback_rec[2] = {{button_callback, NULL},
					    {NULL, NULL }};

    XtSetArg(args[0], XtNlabel, name);
    XtSetArg(args[1], XtNfromVert, chain);
    XtSetArg(args[2], XtNtop, XawChainTop);
    XtSetArg(args[3], XtNbottom, XawChainTop);
    XtSetArg(args[4], XtNleft, XawChainLeft);
    XtSetArg(args[5], XtNright, XawChainLeft);
    XtSetArg(args[6], XtNborderWidth, 0);
    XtSetArg(args[7], XtNvertDistance, 8);
    callback_rec[0].closure = (XtPointer)addr;
    XtSetArg(args[8], XtNcallback, callback_rec);
    chain = XtCreateManagedWidget("rule", commandLocaleWidgetClass, form,
				args, NINE);
}

main (argc, argv)
    int argc;
    char **argv;
{
   String wk;
   char *buf, *addr;
   extern int parse();
   extern int answer_element();

   wk = setlocale(LC_CTYPE , "");
   if(wk == NULL || strcmp(wk , "C") == 0)
       setlocale(LC_CTYPE , "ja_JP.ujis");

   if (!parse())
       exit(1);

   toplevel = XtAppInitialize (&app_con, "xanswer", NULL, ZERO,
			       (Cardinal *)&argc, argv, fallback_resources,
			       (ArgList)NULL, ZERO);


   create_win();
   while (answer_element(&buf, &addr))
       create_button((String)buf, addr);

   XtRealizeWidget(toplevel);
   XtAppMainLoop(app_con);
}
