#include <stdio.h>
#include <malloc.h>
#include "term.h"
#include "explanation.h"

extern widget_addr create_node();
static int explanation();
static List *rule_list;

static widget_addr
reduce(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;
    List *list;
    widget_addr node, goal;
    char *nbuf;

    if (term->id != is_vector)
	return NULL;
    if (term->vector.size != 4)
	return NULL;
    ptr = term->vector.element;
    if (ptr[0].id != is_string)
	return NULL;
    goal = create_node(tree, parent, ptr[0].string.string, NULL, QxtSubgoal);
    if (ptr[1].id != is_string)
	return NULL;
    if (ptr[2].id != is_list)
	return NULL;
    nbuf = malloc(strlen(ptr[1].string.string) + 4);
    strcpy(nbuf, "");
    strcat(nbuf, ptr[1].string.string);
    node = create_node(tree, goal, nbuf, ptr[1].string.string, QxtRule);
    free(nbuf);
    list = (List *)&(ptr[2]);
    while (list != NIL) {
	if (!explanation(list->head, tree, node))
	    return NULL;
	list = list->tail;
    }
    return node;
}

static widget_addr
fact(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    char *nbuf;
    widget_addr node;

    if (term->id != is_string)
	return NULL;
    nbuf = malloc(strlen(term->string.string) + 4);
    strcpy(nbuf, "");
    strcat(nbuf, term->string.string);
    node = create_node(tree, parent, nbuf, term->string.string, QxtFact);
    free(nbuf);
    return node;
}

static widget_addr
one_rule(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;

    if (term->id != is_vector)
	return NULL;
    if (term->vector.size != 2)
	return NULL;
    ptr = term->vector.element;
    if (strcmp(ptr[0].atom.string, "reduce") == 0)
	return reduce(&(ptr[1]), tree, parent);
    if (strcmp(ptr[0].atom.string, "fact") == 0)
	return fact(&(ptr[1]), tree, parent);
    return NULL;
}

static int
inherit_rule(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;
    List *list;
    widget_addr node;

    if (term->id == is_qatom)
	return (strcmp(term->atom.string, "'&void'") == 0)? True: False;
    if (term->id != is_vector)
	return NULL;
    if (term->vector.size != 2)
	return NULL;
    ptr = term->vector.element;
    if (strcmp(ptr[0].atom.string, "up") == 0)
	node = create_node(tree, parent, NULL, NULL, QxtInheritUp);
    else if (strcmp(ptr[0].atom.string, "down") == 0)
	node = create_node(tree, parent, NULL, NULL, QxtInheritDown);
    else
	return False;
    for (list = (List *)&(ptr[1]); list != NIL; list = list->tail)
        if (one_rule(list->head, tree, node) == NULL)
	    return False;
    return True;
}

static int
inherit(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;
    widget_addr node;

    if (term->id != is_vector)
	return False;
    if (term->vector.size != 3)
	return False;
    ptr = term->vector.element;
    node = one_rule(&(ptr[0]), tree, parent);
    if (node == NULL)
	return False;
    if (!inherit_rule(&(ptr[1]), tree, node))
    	return False;
    if (!inherit_rule(&(ptr[2]), tree, node))
    	return False;
    return True;
}

static int
unit_explanation(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;

    if (term->id != is_vector)
	return False;
    if (term->vector.size != 2)
	return False;
    ptr = term->vector.element;
    if (ptr[0].id != is_atom)
	return False;
    if (strcmp(ptr[0].atom.string, "unit") == 0)
	return one_rule(&(ptr[1]), tree, parent) != NULL;
    if (strcmp(ptr[0].atom.string, "inherit") == 0)
	return inherit(&(ptr[1]), tree, parent);
    return False;
}

static int
merge(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    List *list;
    widget_addr node;

    if (term->id != is_list)
	return False;
    node = create_node(tree, parent, NULL, NULL, QxtMerge);
    for (list = (List *)term; list != NIL; list = list->tail) {
	if (!unit_explanation(list->head, tree, node))
	    return False;
    }
    return True;
}

static int
lookup(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;
    int looked, looking;
    char *nbuf;
    widget_addr node;

    if (term->id != is_vector)
	return False;
    if (term->vector.size != 4)
	return False;
    ptr = term->vector.element;
    if (ptr[0].id != is_string)
	return False;
    if (ptr[1].id != is_integer)
	return False;
    if (ptr[2].id != is_integer)
	return False;
    if (ptr[3].id != is_vector)
	return False;
    looked = atoi(ptr[1].integer.string);
    looking = atoi(ptr[2].integer.string);
    nbuf = malloc(strlen(ptr[0].string.string) + 8);
    sprintf(nbuf, "<%d> %s", looked - looking, ptr[0].string.string);
    node = create_node(tree, parent, nbuf, NULL, QxtLookUp);
    free(nbuf);
    if (!explanation(&(ptr[3]), tree, node))
	return NULL;
    return True;
}

static int
explanation(term, tree, parent)
    Term *term;
    char *tree;
    widget_addr parent;
{
    Term *ptr;

    if (term->id != is_vector)
	return False;
    if (term->vector.size != 2)
	return False;
    ptr = term->vector.element;
    if (ptr[0].id != is_atom)
	return False;
    if (strcmp(ptr[0].atom.string, "merge") == 0)
	return merge(&(ptr[1]), tree, parent);
    if (strcmp(ptr[0].atom.string, "lookup") == 0)
	return lookup(&(ptr[1]), tree, parent);
    return unit_explanation(term, tree, parent);
}

int
build_tree(addr)
    char *addr;
{
    Term *term = (Term *)addr;
    widget_addr tree, dialog;
    int bool;
    extern widget_addr create_explanation();
    extern void display_tree();

    tree = create_explanation(&dialog);
    if (term->id != is_vector)
	return False;
    if (term->vector.size != 2)
	return False;
    bool = explanation(&(term->vector.element[0]), tree, NULL);
    rule_list = (List *)&(term->vector.element[1]);
    display_tree(dialog);
    return bool;
}

char
*get_rule(id)
    String id;
{
    List *list;
    Term *ptr;

    for (list = rule_list; list != NIL; list = list->tail) {
	if (list->head->id != is_vector)
	    return NULL;
	ptr = list->head->vector.element;
	if (ptr[0].id != is_string || ptr[1].id != is_string)
	    return NULL;
	if (strcmp(id, ptr[0].string.string) == 0)
	    return (char *)ptr[1].string.string;
    }
    return NULL;
}
