#include "term.h"
print_term(term)
     Term *term;
{
  switch(term->id) {
  case is_vector:
    print_vector(term);
    break;
  case is_list:
    print_list(term);
    break;
  case is_string:
    print_string(term);
    break;
  case is_atom:
    print_atom(term);
    break;
  case is_qatom:
    print_qatom(term);
    break;
  case is_integer:
    print_integer(term);
    break;
  case is_variable:
    print_variable(term);
    break;
  default:
    printf("illegal input for unparse_term\n");
    break;
  };
}

print_vector(vector)
     Vector *vector;
{
  int i, size;
  size = vector->size;
  if(size == 0)
      printf("{}");
  else
    {
      printf("{");
      for(i=0; i < size-1;
	  print_term(vector->element+i),
	  i++,
	  printf(", ")
	  );
      print_term((vector->element)+size-1);
      printf("}");
    }
}

print_list(list)
     List *list;
{
  if(NIL==list->head)
    printf("[]");
  else
    {
      printf("[");
      while(list->tail !=NIL)
	{ 
	  print_term(list->head);
	  printf(", ");
	  list = list->tail;
	};
      print_term(list->head);
      printf("]");
    };
}

print_integer(integer)
     Integer *integer;
{
  printf("%s", integer->string);
}

print_string(string)
     String *string;
{
  printf("%s", string->string);
}

print_atom(atom)
     Atom *atom;
{
  printf("%s",atom->string);
}

print_qatom(qatom)
     Atom *qatom;
{
  printf("%s",qatom->string);
}

print_variable(variable)
     Variable * variable;
{
  printf("%s", variable->string);
}
