#include <stdio.h>
#include <string.h>
#include <limits.h>
#include "qxt.h"
#include "qshell.h"

#define INITIAL_DOC2_SIZE 80

static CommandEntry *
read_command_entry (config, directory)
     FILE *config;
     char *directory;
{
  static CommandEntry cec;
  char *line;
  char *path;
  int path_len;
  char *doc1;
  char *doc2;
  int doc2_len;
  int doc2_allocated;

  line = readline_stream (config);
  if (line == NULL)
    return NULL;
  cec.name = newstring (strtok (line, " \t"));

  path = strtok (NULL, " \t");
  path_len = strlen (qshell_directory) + strlen (directory)
    + strlen (path);
  cec.path = xmalloc (path_len +1);
  strcpy (cec.path, qshell_directory);
  strcat (cec.path, directory);
  strcat (cec.path, path);

  doc1 = strtok (NULL, "\n");
  while (*doc1 == ' ' || *doc1 == '\t')
    doc1++;
  cec.doc1 = newstring (doc1);

  free (line);

  doc2 = xmalloc (INITIAL_DOC2_SIZE);
  doc2_len = 0;
  doc2_allocated = INITIAL_DOC2_SIZE;
  while (1)
    {
      int len;

      line = readline_stream (config);
      if (line == NULL)
	/* end of file */
	break;

      if (*line == 0)
	{ /* brank line */
	  free (line);
	  break;
	}

      len = strlen (line) + 1 /* new line */;
      if (doc2_allocated < doc2_len + len +1 /* last 0 */)
	{
	  doc2_allocated = 2 * (doc2_len + len +1);
	  doc2 = xrealloc (doc2, doc2_allocated);
	}
      strcpy (doc2+doc2_len, line);
      free (line);
      doc2[doc2_len+len-1] = '\n';
      doc2_len += len;
    }
  doc2[doc2_len] = 0;

  cec.doc2 = newstring (doc2);
  free (doc2);

  return &cec;
}

#define NUM_INITIAL_ENTRIES 30

static CommandEntry *
read_configuration_at (directory)
     char *directory;
{
  char *path;
  FILE *config;
  CommandEntry *ce;
  CommandEntry *ce_tmp;
  CommandEntry *command_table;
  int i, n;
  int path_len;

  path_len = strlen (qshell_directory) + strlen (directory)
    + strlen (qshell_config_file_name);
  path = xmalloc (path_len + 1);
  strcpy (path, qshell_directory);
  strcat (path, directory);
  strcat (path, qshell_config_file_name);

  if ((config = fopen (path, "r")) == NULL)
    {
      fprintf (stderr, "can't open configuration file %s\n", path);
      free (path);
      return NULL;
    }
  free (path);

  ce_tmp = (CommandEntry *)xmalloc (sizeof(CommandEntry)
				    * NUM_INITIAL_ENTRIES);
  n = NUM_INITIAL_ENTRIES;

  for (i=0; ce = read_command_entry (config, directory); i++)
    {
      while (i >= n)
	{
	  n *= 2;
	  ce_tmp = (CommandEntry *) xrealloc (ce_tmp,
					      sizeof(CommandEntry) * n);
	}
      ce_tmp[i].name = ce->name;
      ce_tmp[i].path = ce->path;
      ce_tmp[i].doc1 = ce->doc1;
      ce_tmp[i].doc2 = ce->doc2;
    }

  n = i;
  command_table = (CommandEntry *)xmalloc (sizeof (CommandEntry) * (n+1));
  for (i=0; i < n; i++)
    {
      command_table[i].name = ce_tmp[i].name;
      command_table[i].path = ce_tmp[i].path;
      command_table[i].doc1 = ce_tmp[i].doc1;
      command_table[i].doc2 = ce_tmp[i].doc2;
    }

  command_table[n].name = NULL;
  command_table[n].path = NULL;
  command_table[n].doc1 = NULL;
  command_table[n].doc2 = NULL;

  free (ce_tmp);
  return command_table;
}

read_configuration ()
{
  ss_command_table = read_configuration_at ("ss/");
  db_command_table = read_configuration_at ("db/");
  ts_command_table = read_configuration_at ("ts/");
  is_command_table = read_configuration_at ("is/");
}
