/**************************************************************
 *        
 *    STRING OPERATION MODULE           <STROPR.C>
 *                                     '93.12.11  by R.K
 **************************************************************/

#include     <stdio.h>
#include     <string.h>
#include     <sys/types.h>

#include     "oprprot.h"

/**************************************************************
 *     SEARCH "{" 
 *-------------------------------------------------------------
 *  <calling sequence>
 *          p = opr_search_vstart(buf, start)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char next point
 *                                           (not found = NULL)
 *-------------------------------------------------------------
 *  <description>
 *         this function search "{" for buffer.
 *         search start point is argument "start".
 *         when search "{", return this pointer + 1.(next pointer)
 *         if "{" not found, return NULL.
 **************************************************************/
char  *opr_search_vstart(buf, start)     

     char          *buf ;
     unsigned int  start ;
{
  char *ret ;
  int  c = '{';
  char *curpnt ;

  /*** start num check ***/
  if( (strlen(buf)) < start )
    return  NULL;            /*** start num too large ***/ 

  /*** make current pointer ***/
  curpnt = (buf+start);

  /*** search "{" ***/
  ret = strchr(curpnt,c);
  if( ret == NULL )    return  ret; 
  else                 return  ret+1;
}
/***** <<< opr_search_vstart() END >>> *****/

/**************************************************************
 *      SEARCH "}"
 *-------------------------------------------------------------
 *  <calling sequence>
 *          p = opr_search_vend(buf, start)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char next point
 *                                           (not found = NULL)
 *-------------------------------------------------------------
 *  <description>
 *         this function search "}" for buffer.
 *         search start point is argument "start".
 *         when search "}", return this pointer + 1.(next pointer)
 *         if "}" not found, return NULL.
 * 
 *   <ex>
 *
 *         first found
 *              |
 *       .......{..{.....}....}......}...
 *             |         |    |      |
 *           start    ignore ignore found!!(pair of first found "{")
 *************************************************************/
char  *opr_search_vend(buf, start)

     char          *buf ;
     unsigned int  start ;
{
  int  i, stcnt = 0 ;       /*** found "{" counter ***/
  char *curpnt, c ;         /*** current pointer, return pointer ***/
  
  /*** start num check ***/
  if( strlen(buf) < start )
    return  NULL;           /*** start num too large ***/

  /*** search "{" & "}" ***/
  curpnt = (buf+start);

  for(i = 0 ;i < strlen(curpnt) ;i++) {
    c = curpnt[i];          
    if( c == '{' ) {
      stcnt++;
    }
    if( c == '}' ) {
      if( stcnt == 0 )
        return( curpnt+(i+1) );
      else {
	stcnt--;
      }
    }
  }
  return  NULL;             /*** not found ***/
}
/***** <<< opr_search_vend() END >>> *****/

/**************************************************************
 *      SEARCH ","
 *-------------------------------------------------------------
 *  <calling sequence>
 *          p = opr_search_camma(buf, start)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *
 *  <output>
 *          char           *p      : search char next point
 *                                           (not found = NULL)
 *-------------------------------------------------------------
 *  <description>
 *         this function search "," for buffer.
 *         search start point is argument "start".
 *         when search ",", return this pointer + 1.(next pointer)
 *         if "," not found, return NULL.
 **************************************************************/
char  *opr_search_camma(buf, start)     

     char          *buf ;
     unsigned int  start ;
{
  char  c, *curpnt ;
  int   i, sqflag = OFF, dqflag = OFF ;/*** ignore flag ***/
  int   vcnt = 0, lcnt = 0, ccnt = 0 ; /*** search counter ***/
  unsigned  len;

  /*** start num check ***/
  if( strlen(buf) < start )
    return  NULL;                 /*** start num too large ***/

  /*** make current pointer ***/
  curpnt = (buf+start);

  /*** search ***/
  len = strlen(curpnt);
  for( i = 0 ;i < len ;i++ ) {

    /*** search ' ***/
    if( curpnt[i] == '\'' ){  
      if( sqflag == OFF ){
	if( (vcnt == 0) && (lcnt == 0) && (ccnt == 0 ) )
	  sqflag = ON;
      }
      else if( sqflag == ON ){
	if( (vcnt == 0) && (lcnt == 0) && (ccnt == 0 ) )
	  sqflag = OFF;
      }
    }

    /*** search " ***/
    else if( curpnt[i] == '\"' ){
      if( dqflag == OFF ){
	if( (vcnt == 0) && (lcnt == 0) && (ccnt == 0 ) )
	  dqflag = ON;
      }
      else if( dqflag == ON ){
	if( (vcnt == 0) && (lcnt == 0) && (ccnt == 0 ) )
	  dqflag = OFF;
      }
    }

    /*** search "{" ***/
    else if( curpnt[i] == '{' )
	vcnt++;
    /*** search "}" ***/
    else if( curpnt[i] == '}' ){
      if( vcnt > 0 )
	vcnt--;
    }

    /*** search "[" ***/
    else if( curpnt[i] == '[' )
	  lcnt++;
    /*** search "]" ***/
    else if( curpnt[i] == ']' ){
      if( lcnt > 0 )
	lcnt--;
    }

    /*** search "(" ***/
    else if( curpnt[i] == '(' )
      ccnt++;
    /*** search ")" ***/
    else if( curpnt[i] == ')' ){
      if( ccnt > 0 )
	ccnt--;
    }

    /*** search "," ***/
    else if( curpnt[i] == ',' ){
         if( (sqflag == OFF) && (dqflag == OFF) &&
	    (vcnt == 0) && (lcnt == 0) && (ccnt == 0) )
	   return( curpnt+(i+1) );
    }
  }
  return  NULL;                 /*** not found ***/
}
/***** <<< opr_search_camma() END >>> *****/

/***** <<< END OF STROPR.C >>> *********************************/
