/**********************************************************
 *     FUNCTION TOOL MODULE
 *                                        '93.1.12 by R.K
 **********************************************************/
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#include  "pmtool.h"
#include  "pmdata.h"
#include  "oprprot.h"

/**********************************************************
 *     pm_mkdir_name()
 *---------------------------------------------------------
 * module name : pm_mkdir_name()
 *
 * input :
 *         char  *dir   : original dir name
 *         char  *r_buf : changed dir name
 *output :
 *
 **********************************************************/
char  *pm_mkdir_name(dir,r_buf)

     char  *dir;
     char  *r_buf;

{
  if( dir[0] == '/' )
    sprintf(r_buf,".%s",dir);
  else if( dir[0] == '.' )
    strcpy(r_buf,dir);
  else
    sprintf(r_buf,"./%s",dir);
  return  r_buf;
}
/***** <<< pm_mkdir_name END >>> ******/

/**********************************************************
 *     pm_sep_prm()
 *---------------------------------------------------------
 * module name : pm_sep_prm()
 *
 * input :
 *         char  *prm    : original dir name
 *         char  *sepprm :(r) changed dir name
 *output :
 *         int   ret      : parameter number
 **********************************************************/
int  pm_sep_prm(prm,sepprm)

     char  *prm, *sepprm ;
{
  char  *wp, *curp, *sepp ;
  int   i ;

  wp = prm;
  sepp = sepprm;
  for( i = 1; (curp = opr_search_camma(wp,0)) != NULL; i++ ){
    if( wp[0] == '\"'){
      strncpy(sepp,wp+1,(curp-2)-(wp+1));
/***
      sepp[((curp-2)-(wp+1))+1] = NULL;
***/
      sepp[((curp-2)-(wp+1))] = NULL;
    }
    else{
      strncpy(sepp,wp,(curp-1)-wp);
/***
      sepp[((curp-1)-wp)+1] = NULL;
***/
      sepp[((curp-1)-wp)] = NULL;
    }
    wp = curp;
    sepp = ((sepp+strlen(sepp))+1);
  }
  if( wp[0] == '\"' ){
    strcpy(sepp,wp+1);
    sepp[strlen(sepp)-2] = NULL;
  }
  else if( wp[0] == NULL ){
    if( i == 1 )
      i = 0;
  }
  else{
    strcpy(sepp,wp);
    if( sepp[strlen(sepp)-1] == ')' )
      sepp[strlen(sepp)-1] = NULL;
  }
  return  i;
}

/***** <<< pm_sep_prm END >>> ******/

/**********************************************************
 *     pm_update_rev()
 *---------------------------------------------------------
 * module name : pm_update_rev(fname,revstr,date,info,cmprev,uprev)
 *
 * input :
 *        char  *fname      : .info file name
 *        char  *revstr     : revsion string(to .info data)
 *        char  *date       : create date(to .info data)
 *        char  *info       : db info(to .info data)
 *        char  *cmprev     : compare revsion no
 *        char  *uprev      : (r)updated revsion no
 *
 *output :
 *        int  ret          : return status
 *                               0 = normal
 *                              -1 = revsion not found
 **********************************************************/
int  pm_update_rev(fname,revstr,date,info,cmprev,uprev)

     char  *fname, *revstr, *date, *info, *cmprev, *uprev ;

{

  int   ret, i, j, snum, r_end, nestf ;
  char  wbuf[80], wbuf2[2048], sep_rev_buf[2048], sep_date_buf[2048] ;
  char  *wp, *upp, *curp, *wp2 ;
  FILE  *fp ;

  wbuf2[0] = NULL;

  /*** sepalate parameter ***/
  if( (ret = pm_sep_prm(revstr,sep_rev_buf)) <= 0 ){
    return -1;
  }
  if( (pm_sep_prm(date,sep_date_buf)) != ret ){
    return -1;
  }

  /*** compare RevNO ***/
  wp = sep_rev_buf;
  for( i = 1; i <= ret; i++ ){                          /* search "x" */
    if( strcmp(cmprev,wp) ){
      wp = (wp+(strlen(wp)+1));
      continue;
    }
    if( (snum = (ret-i)) <= 0 )
      curp = (wp+strlen(wp));
    else
      curp = ((wp+strlen(wp))+1);
    if( (pm_del_list(wp,wbuf)) < 0 ){
      return  -1;
    }
    if( (upp = strchr(wbuf,',')) == NULL )
      upp = wbuf;
    else{
      wp2 = (upp+1);
      upp = wp2;
      while( (wp2 = strchr(wp2,',')) != NULL )
	upp = (wp2+1);
    }
    nestf = 1;

    /*** revsion up ***/
    while(1){
    LOOP:
      /* search "x(++)" */
      if( nestf == 1 ){
	r_end = atoi(upp);
	r_end++;
	sprintf(upp,"%d",r_end);
	if( ret == 1 ){
	  pm_add_list(wbuf,uprev);
	  nestf = 0;
	  break;
	}
	wp = curp;
	for(j = snum; j > 0; j-- ){
	  if( !strncmp(wbuf,wp+1,strlen(wbuf)) ){
	    nestf++;
	    goto LOOP;
	  }
	  else{
	    wp = (wp+(strlen(wp)+1));
	    continue;
	  }
	}
	pm_add_list(wbuf,uprev);
	nestf == 0;
	break;
      }

      /* search "x,1" */	  
      else if( nestf == 2 ){
	r_end--;
	sprintf(upp,"%d,1",r_end);
	wp = curp;
	for(j = snum; j > 0; j-- ){
	  if( !strncmp(wbuf,wp+1,strlen(wbuf)) ){
	    nestf++;
	    upp = (upp+2);
	    goto LOOP;
	  }
	  else{
	    wp = (wp+(strlen(wp)+1));
	    continue;
	  }
	}
	pm_add_list(wbuf,uprev);
	nestf == 0;
	break;
      }

      /* search "x,0,1" */
      else if( nestf == 3 ){
	sprintf(upp,"0,1");
	wp = curp;
	for(j = snum; j > 0; j-- ){
	  if( !strncmp(wbuf,wp+1,strlen(wbuf)) ){
	    upp = (upp+2);
	    goto LOOP;
	  }
	  else{
	    wp = (wp+(strlen(wp)+1));
	    continue;
	  }
	}
	pm_add_list(wbuf,uprev);
	nestf == 0;
	break;
      }
      if( nestf == 0 )
	break;
    }

    /*** update rev no to .info file ***/
    wp = sep_rev_buf;
    fp = fopen(fname,"w");
    if(ret == 1 )
      sprintf(wbuf2,"%s,%s\n",wp,uprev);
    else{
      sprintf(wbuf2,"%s,",wp);
      wp = (wp+(strlen(wp)+1));
      for(i = 0; i < ((ret-snum)-1); i++ ){
	sprintf(wbuf2+strlen(wbuf2),"%s,",wp);
	wp = (wp+(strlen(wp)+1));
      }
      sprintf(wbuf2+strlen(wbuf2),"%s,",uprev);
      for(i = 0; i < snum; i++ ){
	sprintf(wbuf2+strlen(wbuf2),"%s,",wp);
	wp = (wp+(strlen(wp)+1));
      }
      wbuf2[strlen(wbuf2)-1] = NULL;
      wbuf2[strlen(wbuf2)] = '\n';
    }
    opr_write(fp,wbuf2,strlen(wbuf2));

    /*** update ctrate date to .info file ***/
    pm_get_date(wbuf);
    wp = sep_date_buf;
    if(ret == 1 )
      sprintf(wbuf2,"%s,%s\n",wp,wbuf);
    else{
      sprintf(wbuf2,"%s,",wp);
      wp = (wp+(strlen(wp)+1));
      for(i = 0; i < ((ret-snum)-1); i++ ){
	sprintf(wbuf2+strlen(wbuf2),"%s,",wp);
	wp = (wp+(strlen(wp)+1));
      }
      sprintf(wbuf2+strlen(wbuf2),"%s,",wbuf);
      for(i = 0; i < snum; i++ ){
	sprintf(wbuf2+strlen(wbuf2),"%s,",wp);
	wp = (wp+(strlen(wp)+1));
      }
      wbuf2[strlen(wbuf2)-1] = NULL;
      wbuf2[strlen(wbuf2)] = '\n';
    }
    opr_write(fp,wbuf2,strlen(wbuf2));
    
    /*** save info data ***/
    if( strcmp(info,"\"$void\"") )
      opr_write(fp,info,strlen(info));
    fclose(fp);
    return 0;
  }
  return -1;
}
/***** <<< pm_update_rev END >>> ******/

/**********************************************************
 *     pm_rep_rev()
 *---------------------------------------------------------
 * module name : pm_rep_rev(orgrev,reprev)
 *
 * input :
 *         char  *orgrev       : original revsion
 *         char  *reprev       : replaced revsion
 *
 *output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *--------------------------------------------------------
 * <description>
 *   orgrev = [1,1,2] ---->  reprev = 1_1_2
 **********************************************************/
int  pm_rep_rev(orgrev,reprev)

     char  *orgrev, *reprev;
{

  int  i, j = 0;

  if( (orgrev[0] != '[') || (orgrev[strlen(orgrev)-1] != ']'))
    return -1;
  for( i = 0; orgrev[i] != NULL; i++ ){
    if( orgrev[i] == '[' )
      j++;
    else if( orgrev[i] == ',' )
      reprev[i-j] = '_';
    else if( orgrev[i] == ']' )
      reprev[i-j] = NULL;
    else
      reprev[i-j] = orgrev[i];
  }
  return 0;
}
/***** <<< pm_rep_rev() END >>> ******/

/**********************************************************
 *     pm_mk_rev()
 *---------------------------------------------------------
 * module name : pm_mk_rev(orgrev,mkrev)
 *
 * input :
 *         char  *orgrev       : original revsion
 *         char  *mkrev       : maked revsion
 *
 *output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *--------------------------------------------------------
 * <description>
 *   orgrev = 1_1_2 ---->  reprev = [1,1,2]
 **********************************************************/
int  pm_mk_rev(orgrev,mkrev)

     char  *orgrev, *mkrev;
{

  int  i ;
  char  *wp;

  mkrev[0] = '[';
  wp = mkrev+1;
  for( i = 0; orgrev[i] != NULL; i++ ){
    if( orgrev[i] == '_' )
      wp[i] = ',';
    else
      wp[i] = orgrev[i];
  }
  wp[strlen(wp)] = ']';
  wp[strlen(wp)] = NULL;
  return 0;
}
/***** <<< pm_mk_rev() END >>> ******/

/**********************************************************
 *     pm_add_list()
 *---------------------------------------------------------
 * module name : pm_rep_rev(org,rep)
 *
 * input :
 *         char  *org       : original revsion
 *         char  *rep       : replaced revsion
 *
 *output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *--------------------------------------------------------
 * <description>
 *   orgrev = 1,1,2 ---->  reprev = [1,1,2]
 **********************************************************/
int  pm_add_list(org,rep)

     char  *org, *rep;
{

  strcpy(rep,"[");
  strcpy(rep+strlen(rep),org);
  strcpy(rep+strlen(rep),"]");
  return 0;
}
/***** <<< pm_add_list() END >>> ******/

/**********************************************************
 *     pm_del_list()
 *---------------------------------------------------------
 * module name : pm_del_list(org,rep)
 *
 * input :
 *         char  *org       : original revsion
 *         char  *rep       : replaced revsion
 *
 *output :
 *         int   ret           : return status
 *                               0 = normal
 *                              -1 = abnormal
 *--------------------------------------------------------
 * <description>
 *   orgrev = [1,1,2] ---->  reprev = 1,1,2
 **********************************************************/
int  pm_del_list(org,rep)

     char  *org, *rep;
{

  if( ((org[0] != '[') && (org[strlen(org)-1] != ']')) &&
     ((org[0] != '(') && (org[strlen(org)-1] != ')')) &&
     ((org[0] != '{') && (org[strlen(org)-1] != '}')) )
    return -1;
  strcpy(rep,org+1);
  rep[strlen(rep)-1] = NULL;
  return 0;
}

/**********************************************************
 *     pm_get_date()
 *---------------------------------------------------------
 * module name : pm_get_date(date)
 *
 * input :
 *         char  *date     : (r) get date
 *output :
 *         char  *pnt      : pointer of date buffer
 *--------------------------------------------------------
 * <description>
 *
 *    date = {xx,xx,xx,xx,xx}
 *            |  |  |  |  |
 *            |  |  |  |  - second
 *            |  |  |  ---- min
 *            |  |  ------- day
 *            |  ---------- month
 *            ------------- year
 **********************************************************/
char   *pm_get_date(date)

     char  *date;
{

  FILE    *fp;
  char    wbuf[80] ;
  char    *year, *mon, *day, *min, *sec ;
  unsigned  i, cnt;

  static char  mon_name[12][3] = {
    "Jan","Feb","Mar","Apr","May","Jun",
    "Jul","Aug","Sep","Oct","Nov","Dec"
    };

  opr_cmnd("date > temp");
  fp = fopen("temp","r");
  opr_read(fp,wbuf,sizeof(wbuf));
  fclose(fp);
  opr_cmnd("rm temp");
  for(i = 0; wbuf[i] != '\n'; i++){
    if( (wbuf[i] == ' ') || (wbuf[i] == ':') ){
      if( (wbuf[i+1] == ' ') || (wbuf[i+1] == ':') )
	continue;
      wbuf[i] = NULL;
      cnt++;
      if( cnt == 1 )
	mon = (wbuf+(i+1));
      else if( cnt == 2 )
	day = (wbuf+(i+1));
      else if( cnt == 4 )
	min = (wbuf+(i+1));
      else if( cnt == 5 )
	sec = (wbuf+(i+1));
      else if( cnt == 7 )
	year = (wbuf+(i+1));
    }
  }
  wbuf[i] = NULL;
  for( i = 0; (strncmp(mon_name[i],mon,3)); i++ ){
    if( i == 11 )
      break;
  }
  i++;
  sprintf(date,"{%s,%d,%s,%s,%s}",year,i,day,min,sec);
  return date;
}  
/***** <<< pm_get_date() END >>> ******/

/**********************************************************
 *     pm_read_file()
 *---------------------------------------------------------
 * module name : len = pm_file_read(fp,buf)
 *
 * input :
 *         FILE  *fp       : file pointer
 *         char  *buf      : (r) get data to file
 *output :
 *         int   len       : read data length
 *--------------------------------------------------------
 * <description>
 *     This function read data from file.
 *     if buffer length too short, memory realloc (+BUF_MAX).
 *
 **********************************************************/
int  pm_read_file(fp,buf)

     FILE  *fp;
     char  *buf;

{

  int i, cnt = 1 ;

  for( i = 0; (opr_read(fp,&buf[i],1)) > 0; i++ ){
    if( i == ((BUF_MAX * cnt)-1) ){
      cnt++;
      if( (buf = realloc(buf,(BUF_MAX * cnt))) == NULL )
	return -1;
      if( (wr_data = realloc(wr_data,(BUF_MAX * cnt)+1024)) == NULL )
	return -1;
      alloc_cnt_wr++;
    }
  }
  buf[i] = NULL;
  return i+1;
}

/*** <<< pm_read_file() END >>> ***/

/*** <<< END OF PMTOOL.C >>> ***********************/
