#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include "pmfunc.h"
#include "pmdata.h"
#include "oprprot.h"

/*** prototypes ***/
char  *get_command();
void  save_log_data();

/*******************************************************************
 *   PM function handler
 *                                       '93.1.12 by R.K
 ******************************************************************/
pm(sn,buf)

     int sn;
     char *buf;
{

  int  i ;
  char *c, *prmp;
  char *r;
  char wkbuf[128];

  /*** command handling *****************************************/
  for(;;){

    /*** get read data ***/
    for(i = 0; (read(sn,&buf[i],1)) > 0; i++ ){
      if( buf[i] == '\n' )
	  break;
      if( i == ((BUF_MAX * alloc_cnt_rd)-1) ){
	alloc_cnt_rd++;
	if( (buf = realloc(buf,(BUF_MAX * alloc_cnt_rd))) == NULL ){
	  printf("pm_server: memory reallocation\n");
	  exit(1);
	}
	alloc_cnt_prm++;
	if( (prm_buf = realloc(prm_buf,(BUF_MAX * alloc_cnt_prm))) == NULL ){
	  printf("pm_server: memory reallocation\n");
	  exit(1);
	}
      }
    }
    buf[i] = NULL;
    
    /*** save rx data log in "pm_log" file ***/
    save_log_data(1,buf);
    
    /*** command get ***/
    c = get_command(buf);
    
    /*** commands ***/
    if(!strcmp(c,"end_PM")){ /*** end_PM ***/
      end_PM(sn,buf);
      break;
    }
    else if(!strcmp(c,"reset")){ /*** reset ***/
      reset(sn,buf);
    }
    else if(!strcmp(c,"create_PM")){ /*** create_PM ***/
      create_PM(sn,buf);
    }
    else if(!strcmp(c,"ls")){ /*** ls ***/
      prmp = (buf+strlen(c));
      ls_c(sn,prmp);
    }
    else if(!strcmp(c,"ls_l")){ /*** ls_l ***/
      prmp = (buf+strlen(c));
      ls_l_c(sn,prmp);
    }
    else if(!strcmp(c,"mkdir")){ /*** mkdir ***/
      prmp = (buf+strlen(c));
      mkdir_c(sn,prmp);
    }
    else if(!strcmp(c,"rmdir")){ /*** rmdir ***/
      prmp = (buf+strlen(c));
      rmdir_c(sn,prmp);
    }
    else if(!strcmp(c,"rm")){ /*** rm ***/
      prmp = (buf+strlen(c));
      rm_c(sn,prmp);
    }
    else if(!strcmp(c,"rm_all")){ /*** rm_all ***/
      prmp = (buf+strlen(c));
      rm_all_c(sn,prmp);
    }
    else if(!strcmp(c,"check")){ /*** check ***/
      prmp = (buf+strlen(c));
      check_c(sn,prmp);
    }
    else if(!strcmp(c,"purge")){ /*** purge ***/
      prmp = (buf+strlen(c));
      purge_c(sn,prmp);
    }
    else if(!strcmp(c,"get_text_DB")){ /*** get_text_DB ***/
      prmp = (buf+strlen(c));
      get_text_DB(sn,prmp);
    }
    else if(!strcmp(c,"get_DB")){ /*** get_DB ***/
      prmp = (buf+strlen(c));
      get_DB(sn,prmp);
    }
    else if(!strcmp(c,"get_last_version")){ /*** get_last_version ***/
      prmp = (buf+strlen(c));
      get_last_version(sn,prmp);
    }
    else if(!strcmp(c,"put_DB_with_qxt")){ /*** put_DB_with_qxt ***/
      prmp = (buf+strlen(c));
      put_DB_with_qxt(sn,prmp);
    }
    else if(!strcmp(c,"put_DB")){ /*** put_DB ***/
      prmp = (buf+strlen(c));
      put_DB(sn,prmp);
    }
    else if(!strcmp(c,"update_DB")){ /*** update_DB ***/
      prmp = (buf+strlen(c));
      update_DB(sn,prmp);
    }
    else{
      sprintf(wr_data,"result_%s(abnormal(\"command not found\"))\n",c);
      write(sn,wr_data,strlen(wr_data));
    }
    /*** save tx data in "pm_log" file ***/
    save_log_data(0,wr_data);

    /*** memory reallocation ***/
    if( alloc_cnt_rd > 1 ){
      alloc_cnt_rd = 1;
      buf = realloc(buf,BUF_MAX);
    }
    strncpy(buf,"",BUF_MAX);
    if( alloc_cnt_wr > 1 ){
      alloc_cnt_wr = 1;
      wr_data = realloc(wr_data,BUF_MAX);
    }
    strncpy(wr_data,"",BUF_MAX);
    if( alloc_cnt_prm > 1 ){
      alloc_cnt_prm = 1;
      prm_buf = realloc(prm_buf,BUF_MAX);
    }
    strncpy(prm_buf,"",BUF_MAX);
  }

  /*** save tx data in "pm_log" file ***/
  save_log_data(0,wr_data);
  strncpy(buf,"",BUF_MAX);
  strncpy(wr_data,"",BUF_MAX);
  strncpy(prm_buf,"",BUF_MAX);
}
/*** <<< pm() end >>> ***/

/*******************************************************************
 *   SUB ROUTIN                                  <save_log_data()>
 *                                       '93.2.15 by R.K
 *-----------------------------------------------------------------
 * <INPUT>
 *      int   prompt   : prompt sel flag
 *                          0 = TX DATA
 *                         !0 = RX DATA
 *
 *      char  *databuf : command data save buffer pointer
 *
 * <OUTPUT>
 *      none
 * 
 ******************************************************************/
void  save_log_data(prompt,databuf)

     int   prompt;
     char  *databuf;

{

  char  wbuf[128];
  FILE *fp ;
  int  i;

  /*** save data to buffer ***/
  if( prompt == 0 )
    strcpy(wbuf,"[ TX DATA >> ] : ");
  else
    strcpy(wbuf,"[ RX DATA << ] : ");
  opr_cmnd("date > temp");
  fp = fopen("temp","r");
  fgets(wbuf+strlen(wbuf),((sizeof(wbuf))-(strlen(wbuf))),fp);
  fclose(fp);
  opr_cmnd("rm temp");
  strcpy(wbuf+(strlen(wbuf)-1)," : ");
  strncpy(wbuf+strlen(wbuf),databuf,25);
  if(wbuf[strlen(wbuf)-1] == '\n' )
    wbuf[strlen(wbuf)-1] = NULL;
  else
    wbuf[73] = NULL;

  /*** save data in "pm_log" file ***/ 
  fp = fopen("pm_log","a");
  opr_write(fp,wbuf,strlen(wbuf));
  fputc('\n',fp);
  fclose(fp);
}
/*** <<< save_log_data() end >>> ***/
  
/***** <<< END OF pm.c >>>******/
